#ifndef MEM_ZONE_H 
#define MEM_ZONE_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>

#include "memdata.h"

class KMemStat ;

class MemZone : public QWidget
{
	friend KMemStat ;

	Q_OBJECT
public:
	MemZone( MemData *m,
		QWidget *parent = 0, const char *name = 0);
	virtual ~MemZone();

	inline int pagesOnRow() { return pages_on_row ; }
	inline int pagesInColumn() {return pages_in_column ; }
	int scrollOffset() ;

	void redraw() ;

	static void setColor( QColor, int ) ;
	static QColor getColor( int ) ;
 	static const char* getMemoryType( int type ) ;

	static const int MIN_PAGES_ON_ROW ;
	static const int MAX_PAGES_ON_ROW ;
	static const int DEFAULT_PAGES_ON_ROW ;
	static const int number_of_colors =6; 
  
public slots:
	void setScrollOffset( int page ) ;

	void setPagesOnRow( int ) ;
protected:
	void setPagesInColumn() ;

protected slots:
	void paintEvent( QPaintEvent * ) ;
	void resizeEvent( QResizeEvent *) ;
	void mousePressEvent( QMouseEvent* ) ;
	void mouseReleaseEvent( QMouseEvent* ) ;
	void mouseMoveEvent( QMouseEvent* ) ;
	void leaveEvent( QEvent* ) ;

protected slots:
	void redrawBuffer() ;

signals:
	void notifyMousePressEvent( QMouseEvent * ) ;
	void pageOffsetChanged( int page ) ;
 	void scrollOffsetChanged( int page ) ;

private:
	inline int numberOfPages() { return memdata->numberOfPages() ; } 
	inline int pageOffset() { return page_offset ; }
	void setPageOffset( int page ) ; 
	void addToPageOffset( int pages ) ;

	int lineOffset() ;
	int linesVisible() ;

	int pageToScroll(int);
	int scrollToPage(int);

	QPainter *painter ;

	/* this is where we get all the data */
	MemData *memdata ;

	/* buffer for displaying data */
	QPixmap *draw_buffer ;

	/* where should we start displaying? */
	int page_offset ;

	/* the number of pages on a row */
	int pages_on_row ;
	int pages_in_column ;
	/* these so used to be int */
	float page_width ;
	float page_height ;

	static QColor memcolors[number_of_colors] ;

	/* used for scrolling with the mouse */
	bool mouse_pressed ;
	int last_page_offset ;
	QPoint mouse_position ;

	/* replace this with real variables later on */
	int he() ;
	int wi() ;
};

#endif // MEM_ZONE_H 
