/*
    KMLOCfg
    
    A utility to view and print facsimiles received with the
    ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#include "preferences.h"
#include "preferences.moc"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <termios.h>

#include <qglobal.h>
#include <qtabdialog.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qtooltip.h>

#include <kapp.h>
#include <kconfig.h>

#include "global.h"



Preferences::Preferences( QWidget * parent, const char * name ) : QTabDialog ( parent, name )
{
	QGridLayout * grid;
	QBoxLayout * vbox, * svbox;
	QLabel * label;
	QGroupBox * gb;

	gotToolTips = FALSE;

	KsConfig = mykapp->getConfig();

	page1 = new QWidget( this, "prefspage1" );
	CHECK_PTR( page1 );
	page2 = new QWidget( this, "prefspage2" );
	CHECK_PTR( page2 );

	addTab( page1, i18n("General") );
	addTab( page2, i18n("Modem") );

	/* Page 1: General */
	vbox = new QVBoxLayout( page1, 12 );

	gb = new QGroupBox( i18n("User Interface"), page1 );
	svbox = new QVBoxLayout( gb, 10 );
	svbox->addSpacing( 8 );

	gen_tooltips = new QCheckBox( i18n("Show Tooltips"), gb );
	gen_tooltips->setMinimumSize( gen_tooltips->sizeHint() );
	svbox->addWidget( gen_tooltips );
	svbox->activate();
	
	vbox->addWidget( gb );

	vbox->addStretch( 1 );
	vbox->activate();

	/* Page 2: Device */
	vbox = new QVBoxLayout( page2, 12 );

	gb = new QGroupBox( i18n("Modem Device"), page2 );

	grid = new QGridLayout( gb, 3, 3, 12 );

	grid->addRowSpacing( 0, 8 );

	label = new QLabel( i18n("Device:"), gb );
	label->setMinimumSize( label->sizeHint() );
	label->setAlignment( AlignRight | AlignVCenter );
	grid->addWidget( label, 1, 0, AlignRight | AlignVCenter );

	mod_device = new QLineEdit( gb );
	mod_device->setMinimumSize( mod_device->sizeHint() );
	grid->addMultiCellWidget( mod_device, 1, 1, 1, 2 );

	label = new QLabel( i18n("Speed:"), gb );
	label->setMinimumSize( label->sizeHint() );
	label->setAlignment( AlignRight | AlignVCenter );
	grid->addWidget( label, 2, 0 );

	mod_speed = new QComboBox( FALSE, gb );
	mod_speed->insertItem( " 300 Bps ", 0 );
	mod_speed->insertItem( " 2400 Bps ", 1 );
	mod_speed->insertItem( " 9600 Bps ", 2 );
	mod_speed->insertItem( " 19200 Bps ", 3 );
	mod_speed->insertItem( " 38400 Bps ", 4 );
#ifdef B57600
	mod_speed->insertItem( " 57600 Bps ", 5 );
#endif
#ifdef B115200
	mod_speed->insertItem( " 115200 Bps ", 6 );
#endif
#ifdef B230400
	mod_speed->insertItem( " 230400 Bps ", 7 );
#endif
	mod_speed->setMinimumSize( mod_speed->sizeHint() );
	grid->addWidget( mod_speed, 2, 1 );

	grid->setColStretch( 2, 1 );

	grid->activate();

	vbox->addWidget( gb );
	vbox->addStretch( 1 );
	vbox->activate();

	setOKButton( i18n("OK") );
	setDefaultButton( i18n("Default") );
	setApplyButton( i18n("Apply") );
	setCancelButton( i18n("Cancel") );

	reset();

	connect( this, SIGNAL(defaultButtonPressed()), SLOT(reset()) );
	connect( this, SIGNAL(applyButtonPressed()), SLOT(apply()) );

	setCaption( i18n("KMLOCfg Preferences") );

	resize( sizeHint() );
}


Preferences::~Preferences()
{
}


void Preferences::addToolTips( bool on )
{
	if (on == gotToolTips)
		return;

	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add( gen_tooltips, i18n("Show Tooltips in Dialogs") );
		QToolTip::add( mod_device, i18n("Device of the Modem") );
		QToolTip::add( mod_speed, i18n("Speed for serial Communication") );
	} else {
		QToolTip::remove( gen_tooltips );
		QToolTip::remove( mod_device );
		QToolTip::remove( mod_speed );
	}
}	


bool Preferences::genTooltips()
{
	KsConfig->setGroup( "General" );
	return KsConfig->readBoolEntry( "ToolTips", PREF_GEN_TOOLTIPS );
}


const QString Preferences::modDevice()
{
	KsConfig->setGroup( "Modem" );
	return KsConfig->readEntry( "Device", PREF_MOD_DEVICE );
}


int Preferences::modSpeed()
{
	KsConfig->setGroup( "Modem" );
	return KsConfig->readNumEntry( "Speed", PREF_MOD_SPEED );
}


void Preferences::reset()
{
	KsConfig->setGroup( "General" );
	gen_tooltips->setChecked( KsConfig->readBoolEntry( "ToolTips", PREF_GEN_TOOLTIPS) );

	KsConfig->setGroup( "Modem" );
	mod_device->setText( KsConfig->readEntry("Device", PREF_MOD_DEVICE) );
	mod_speed->setCurrentItem( KsConfig->readNumEntry("Speed", PREF_MOD_SPEED) );
}


void Preferences::apply()
{
	KsConfig->setGroup( "General" );
	KsConfig->writeEntry( "ToolTips", gen_tooltips->isChecked() );
	
	KsConfig->setGroup( "Modem" );
	KsConfig->writeEntry( "Device", mod_device->text() );
	KsConfig->writeEntry( "Speed", mod_speed->currentItem() );

	KsConfig->sync();

	emit apply_clicked();
}
