/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef FAXVIEW_H 
#define FAXVIEW_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlistview.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qevent.h>

#include "senderaliases.h"


#define CONTEXT_ID_VIEW   0
#define CONTEXT_ID_PRINT  1
#define CONTEXT_ID_MAIL   2
#define CONTEXT_ID_DELETE 3
#define CONTEXT_ID_ALIAS  4



class FaxViewItem : public QListViewItem
{
public:
	FaxViewItem( QListView * parent = 0, const char * name = 0 );
	~FaxViewItem();

	void setNew( bool n, QPixmap & yes, QPixmap & no );
	bool isNew();
	void setSender( const char * s );
	const char * sender();
	void setPages( int p );
	int pages();
	void setSize( int s );
	int size();
	void setFile( bool f, QPixmap & yes, QPixmap & no );
	bool hasFile();

private:
	bool new_flag;
	char sid[21];
	int pg;
	int siz;
	bool file_flag;
};


inline bool FaxViewItem::isNew()
{ return new_flag; }

inline const char * FaxViewItem::sender()
{ return sid; }

inline int FaxViewItem::pages()
{ return pg; }

inline int FaxViewItem::size()
{ return siz; }

inline bool FaxViewItem::hasFile()
{ return file_flag; }



class FaxView : public QListView
{
	Q_OBJECT
public:
	FaxView( QWidget * parent = 0, const char * name = 0 );
	~FaxView();

	void loadDir();
	void saveDir();
	void purgeDir();
	void rebuildDir();

	void addFaxItem( const char * name, const char * time, int fsize );

	void setFaxItemNew( bool isnew );
	void setFaxItemNew( FaxViewItem * item, bool isnew );
	bool faxItemNew();
	bool faxItemNew( FaxViewItem * item );

	const char * faxItemName();
	const char * faxItemName( FaxViewItem * item );
	const char * faxItemSender();
	const char * faxItemSender( FaxViewItem * item );
	const char * faxItemAlias();
	const char * faxItemAlias( FaxViewItem * item );

	void setFaxItemFile( bool fexists );
	void setFaxItemFile( FaxViewItem * item, bool fexists );
	bool faxItemFile();
	bool faxItemFile( FaxViewItem * item );

	SenderAliases * aliases;

protected:
	virtual void mousePressEvent( QMouseEvent * e );

private slots:
	void selectionChangedSlot( QListViewItem * item );
	void doubleClickedSlot( QListViewItem * item );
	void refreshAliases();
	void contextMenuSlot( int id );

signals:
	void hasSelection( bool );
	void viewRequested( FaxViewItem * );

	void contextView();
	void contextPrint();
	void contextMail();
	void contextDelete();
	void contextAlias();
	
private:
	void setItem( FaxViewItem * item, const char * name, bool isnew, const char * time, const char * sender, int pages, int fsize );

	bool got_tooltips;
	QPixmap yes_pix, no_pix;

	QListViewItem * selectedItem;

	QPopupMenu * context_menu;
};


#endif // FAXVIEW_H 
