/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef KMLOFAX_H 
#define KMLOFAX_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <X11/Xlib.h>
#undef TrueColor	// Avoid Qt <-> X11 conflict

#include <qlistview.h>
#include <qstring.h>

#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kconfig.h>
#include <kapp.h>

#include "faxview.h"
#include "preferences.h"
#include "downloaddlg.h"
#include "preview.h"
#include "printdlg.h"
#include "maildlg.h"



class KMLOFaxApp : public KApplication
{
public:
	KMLOFaxApp( int & argc, char ** argv, const QString & rAppName );

protected:
	virtual bool x11EventFilter( XEvent * ev );
};



class KMLOFax : public KTopLevelWidget
{
	Q_OBJECT
public:
	KMLOFax( const char * name = 0 );
	~KMLOFax();

public slots:
	void downloadFax();
	void viewFax();
	void printFax();
	void mailFax();
	void deleteFax();
	void purgeDir();
	void rebuildDir();

	void senderAlias();

	void newPrefs();
	void showPrefs();

	void showSenderList();

	void invokeHelp();
	void showAbout();

private slots:
	void toggleToolbar();
	void toggleStatusbar();
	void gotSelection( bool on );
	void viewRequestedSlot( FaxViewItem * item );
	void quit();
	void fetchMessage( const char * msg );
	void fetchFile( const char * name, const char * time, int size );
	void fetchDone();

private:
	KConfig * KsConfig;

	KMenuBar * menuBar;
	KToolBar * toolBar;
	bool toolBarOn;
	KStatusBar * statusBar;
	bool statusBarOn;
	FaxView * view;
	Preview * preview;
	DownloadDlg * downloaddlg;

	int menu_item_dl;
	int menu_item_view;
	int menu_item_prt;
	int menu_item_mail;
	int menu_item_del;
	int menu_item_ali;
	int menu_item_tool;
	int menu_item_status;
};

#endif // KMLOFAX_H 
