#ifndef __CLIENTBASE_H_
#define __CLIENTBASE_H_

#include <ksock.h>

#include <qwidget.h>
#include <qlist.h>
#include <qstring.h>
#include <qprogressdialog.h>

#include <iostream.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "resource.h"

class ClientBase
{
public:
  ClientBase(QWidget* parent);
  virtual ~ClientBase();

 /** Used to check a pop3 for mail. Don't call this method until you have called connect and you are sure a 
   * connection is open. If you do call this with out a connection, it should be able to recover. It works by
   * calling a series of commands, like USER, STAT, PASS and then calls _GetSocketInput to get the results of
   * the command. At anytime during execution it can and will bail out if things go wrong someplace.
   *
   * @param headerlist A list of HeaderInfoStructs that will be filled when mail is found waiting on the
   * server. This list should be created and emptied before being passed in because this method will just attempt
   * to append to the end of it.
   *
   * @param timeOutLength This is the length of time KNewMail will sit and wait for the server to respond
   * to a certain request. About 8 seconds is recommended. This value should be in seconds.
   */
  virtual bool checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo);

protected:
  /** sets the date field of the HeaderInfo struct with the date you pass in.
   */
  void setDate(HeaderStruct* headerInfo, QString dateString);

  /** Initializes the progrss dialog
   */
  void initProgressDialog(QString address);
  void destroyProgrssDialog();

 /** Basicaly does the same thing as _GetSocketInput except that it also sends the top command to the pop server.
   * Then it parses the information returned by the pop server to get the subject/to/from fields and put them in
   * a headerstruct, headerInfo
   *
   * @param headerInfo An outgoing parameter that will be filled with the message subject/from/to fields.
   *
   * @return Same as GetSocketInput
   */
  int getHeaderOffSocket(HeaderStruct* headerInfo);

  void  parseHeaderLine(QString headerLine, HeaderStruct* headerInfo);

  /** Checks the header to see if it should be filtered in some way. 
   */
  bool runThroughFilter(HeaderStruct* headerInfo);

  /** Opens a connection to the server specified
   */
  bool openConnection(ServerStruct* serverInfo);

  void destroyConnection();

  /** Reads a line from the socket stream and returns it. The method will return false 
   * if there was nothing to read, and true otherwise
   */
  bool readLine(QString &response);

  /** Writes the contents of 'command'  to the socket stream
   */
  void writeLine(QString command);

  QProgressDialog* fProgress;

  QWidget* fParent;

  KSocket *fClientSocket;

  // -- Socket stuff ---
  fd_set fRfds;
  struct timeval fTv;
  int fTimeOutLength;
  // -------------
};

#endif
