#include "clientlocal.h"
#include "filterconfigdlg.h"

// QT includes
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kapp.h>

ClientLocal::ClientLocal(QWidget* parent) : ClientBase(parent)
{
}

ClientLocal::~ClientLocal()
{
}

bool ClientLocal::checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo)
{
  HeaderStruct *headerInfo  = NULL;
  QString pathToMail, string;
  int loopCount  = 0;
  KConfig *config = kapp->getConfig();

  pathToMail = serverInfo->address;
  pathToMail += "/";
  pathToMail += serverInfo->username;

  // First we will attempt to open the file that mail is stored in.
  // Because the user was requested to enter this info in the config
  // file, it should be stored as the username

  QFile inFile(pathToMail);

  if (!inFile.open(IO_ReadOnly))
    return 1;

  QTextStream textStream( &inFile );
  //string = textStream.readLine();

  while ( (!textStream.eof() )  && (loopCount < 5000))
    {        // until end of file...

      string = textStream.readLine();
      //cout << "String: " << string << endl;

      if (string.contains("Date:", TRUE) > 0)
	{
	  if (string.contains("Resent-Date:", TRUE) > 0)
	    {
	      string = string.right(string.length() - 12);
	    }

	  else
	    {
	      headerInfo = new HeaderStruct;
	      headerInfo->address = pathToMail;
	  
	      string = string.right(string.length() - 5);
	    }

	  setDate(headerInfo, string);
	}

      else if (string.contains("From:", TRUE) > 0)
	{
	  if (string.contains("Resent-From:", TRUE) > 0)
	    {
	        
	      if (headerInfo != NULL)
		{
		  headerInfo->from = string.right(string.length() - 12);
		}
	    }

	  else
	    {
	      
	      if (headerInfo != NULL)
		{
		  headerInfo->from = string.right(string.length() - 5);
		}
	    }
	}

      else if (string.contains("To:", TRUE) > 0)
	{
	    if (headerInfo != NULL)
	      {
		headerInfo->to = string.right(string.length() - 3);
	      }
	}

      else if (string.contains("Subject:", TRUE) > 0)
	{
	  if (headerInfo != NULL)
	    {
	      headerInfo->subject = string.right(string.length() - 8);

	        // Now run it through the filter
	      config->setGroup("FILTER");
	      if (config->readBoolEntry("UseFiltering", false))
		if (runThroughFilter(headerInfo))
		  {
		    switch (config->readNumEntry("Command", COMBO_ID_IGNORE))
		      {
		      case COMBO_ID_IGNORE:
			//cout << "Header being ignored" << endl;
			delete (headerInfo);
			break;
			
		      case COMBO_ID_DELETE:
			// Can't delete local mail
			break;
		      }
		  }
		else
		  headerList->append(headerInfo);
	      else
		headerList->append(headerInfo);
	    }
	}

      loopCount++;
   
    }
  
  if (loopCount > 5000)
    {
      ERROR("Ran checkLocalMail() loop 5000 times. Probably stuck in infinite loop. Bailing out before any damage is done.");
    }

  inFile.close();
  return true;
}
