#include "configdialog.h"
#include "mailboxconfigdlg.h"
#include "baseconfigdlg.h"
#include "notifconfigdlg.h"
#include "uiconfigdlg.h"
#include "aboutconfigdlg.h"
#include "filterconfigdlg.h"

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

#include <iostream.h>

CConfigDialog::CConfigDialog(QList<ServerStruct> *mailboxList, QWidget *parent, const char* name) :  QTabDialog( parent, name, TRUE )
{
  setCaption(i18n("KNewMail Configuration"));
  setGeometry(200, 200, 450, 250);

  fMailBoxConfigDlg = new CMailBoxConfigDlg(mailboxList, this, "MailBoxConfigDlg");
  fBaseConfigDlg = new CBaseConfigDlg(this, "BaseConfigDlg");
  fNotifConfigDlg = new CNotifConfigDlg(this,"NotifConfigDlg"); 
  fUIConfigDlg = new CUIConfigDlg(this, "UIConfigDlg");
  fFilterConfigDlg = new CFilterConfigDlg(this, "FilterConfigDlg");
  fAboutConfigDlg = new CAboutConfigDlg(this, "AboutConfigDlg");

  addTab(fBaseConfigDlg, "Base");
  addTab(fMailBoxConfigDlg, "Mailbox");
  addTab(fNotifConfigDlg, "Notification");
  addTab(fUIConfigDlg, "Interface");
  addTab(fFilterConfigDlg, "Filter");
  addTab(fAboutConfigDlg, "About");
  
  setOkButton();
  setApplyButton();
  setCancelButton();

  
}


CConfigDialog::~CConfigDialog()
{
  delete(fMailBoxConfigDlg);
  delete(fBaseConfigDlg);
  delete(fNotifConfigDlg);
  delete(fUIConfigDlg);
  delete(fAboutConfigDlg);
  delete(fFilterConfigDlg);
}

void CConfigDialog::writeOptions()
{
  KConfig* config = kapp->getConfig();

  fNotifConfigDlg->writeOptions();
  fBaseConfigDlg->writeOptions();
  fMailBoxConfigDlg->writeOptions();
  fUIConfigDlg->writeOptions();
  fFilterConfigDlg->writeOptions();

  config->sync();
}

#include "configdialog.moc"
