/*
	This code was originally taken from the KGet application. It has been
   modified by Mike Pilone to work in the KNewMail program.


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#include <kwm.h>
#include <kapp.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <klocale.h>

#include <iostream.h>
#include <stdlib.h>

#include <qpixmap.h>
#include <qtimer.h>

#include "docking.h"

DockWidget::DockWidget(QWidget *parent, const char *name) : QWidget(0, name, 0) 
{
  fParent = parent;

  docked = false;
  
  // put itself in the panel
  setupDock();

  // popup menu for right mouse button
  popup_m = new QPopupMenu();
  toggleID = popup_m->insertItem(i18n("UnDock"),
				 this, SLOT(toggle_window_state()));
  popup_m->insertSeparator();
  popup_m->insertItem(i18n("Force Check"), fParent, SLOT( slotForceCheck() ));
  popup_m->insertItem(i18n("Mail Client"), fParent, SLOT( slotLaunchApp() ));
  popup_m->insertSeparator();
  popup_m->insertItem(i18n("Exit"), fParent, SLOT( slotAppExit() ));

  // setup the timer for the animation.
  fTimer = new QTimer(this, "Timer");
  connect(fTimer, SIGNAL(timeout()), this, SLOT(slotTimerDone()));

  // setup properties of the icon list
  fAnimIcon.setAutoDelete(TRUE);

  
  // -- SETUP ANIMATION ICON --------------------------
  setupAnimIcon();
  
  // -- SET CURRENT ICON -----------------------------
  setIconNormal();
}


DockWidget::~DockWidget() 
{
  delete (popup_m);
  delete (fTimer);
  fAnimIcon.clear();
}

void DockWidget::setupDock() 
{
  
  if (!docked) 
    {
      
      // prepare panel to accept this widget
      KWM::setDockWindow (this->winId());
      
      // that's all the space there is
      this->setFixedSize(24, 24);
      
      // finally dock the widget
      this->show();
      
      docked = FALSE;
    } 
}

void DockWidget::dock()
{
  fParent->hide();
  docked = TRUE;
}

void DockWidget::undock() 
{
  fParent->show();
  docked = FALSE;

  /* 
  if (docked) {
    
    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough (seems to be necessary though).
    
    this->hide();
    
    this->destroy(true, true);
    
    // recreate window for further dockings
    this->create(0, true, false);
    
    docked = false;
  }
  */
}

const bool DockWidget::isDocked() 
{
  
  return docked;
  
}

void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close kget window on left mouse button 
  if ( e->button() == LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on right mouse button
  
  if ( e->button() == RightButton ) {
    int x = e->x() + this->x();
    int y = e->y() + this->y();

    QString text;
    if(fParent->isVisible())
      text = i18n("Dock");
    else
      text = i18n("UnDock");
    
    popup_m->changeItem(text, toggleID);
    popup_m->popup(QPoint(x, y));
    popup_m->exec();
  }
  

}

void DockWidget::toggle_window_state() 
{
  
  // restore/hide connect-window
    if (fParent->isVisible())
      {
      fParent->hide();
      docked = TRUE;
      }

    else 
      {
      fParent->show();
      KWM::activate(fParent->winId());
      docked = FALSE;
      }
}

void DockWidget::paintEvent (QPaintEvent *) 
{ 
  if (fIcon == NULL)
    cout << "ERROR: Couldn't load icon!" << endl;
  else
    bitBlt(this, 0, 0, fIcon);
}

void DockWidget::setIconNormal()
{
  // stop the timer from running
  fTimer->stop();

  // Set the icon to the first one. That is the normal, no mail icon.
  fIcon = fAnimIcon.first();

  repaint();
}

void DockWidget::setIconAnimated()
{
  // start the timer
  fTimer->start(1000, FALSE);

  slotTimerDone();
}

void DockWidget::setupAnimIcon()
{
  // start setting up each icon.
  fIcon = new QPixmap(Icon("knewmail_panel_normal.xpm"));
  fAnimIcon.append(fIcon);
  
  fIcon = new QPixmap(Icon("knewmail_panel_1.xpm"));
  fAnimIcon.append(fIcon);
  
  fIcon = new QPixmap(Icon("knewmail_panel_2.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_3.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_4.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_5.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_6.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_7.xpm"));
  fAnimIcon.append(fIcon);

  fIcon = new QPixmap(Icon("knewmail_panel_8.xpm"));
  fAnimIcon.append(fIcon);
}

void DockWidget::slotTimerDone()
{
  fIcon = fAnimIcon.next();

  if (fIcon == NULL)
    fIcon = fAnimIcon.first();

  repaint();
}

#include "docking.moc"
