#ifndef __FILTERCONFIGDLG_H_
#define __FILTERCONFIGDLG_H_

#include <qdialog.h>
#include <qwidget.h>
#include <qdatetime.h>
class QCheckBox;
class QComboBox;
class QLineEdit;
class QGroupBox;
class QLabel;
class KDatePicker;

const int COMBO_ID_DELETE = 0;
const int COMBO_ID_IGNORE = 1;
const int COMBO_ID_FROM = 0;
const int COMBO_ID_SUBJECT = 1;
const int COMBO_ID_DATE = 2;
const int COMBO_ID_BEFORE_DATE = 0;
const int COMBO_ID_AFTER_DATE = 1;
const int COMBO_ID_SAMEAS_DATE = 2;

class CFilterConfigDlg : public QDialog
{
  Q_OBJECT
  
public:
  CFilterConfigDlg(QWidget* parent, const char* name);
  ~CFilterConfigDlg();

  void writeOptions();

  enum eDateFieldOptions { BeforeDate = 0, AfterDate, SameAsDate };

private:
  QCheckBox* fUseFilterChkBox;

  QComboBox* fCommand;
  QComboBox* fField;
  QComboBox* fDateOptions;

  QLineEdit* fContainingText;

  QGroupBox* fFilterOptionsGrpBox;

  KDatePicker* fDatePicker;

  QLabel* fStaticTextA;
  QLabel* fStaticTextB;
  QLabel* fStaticTextC;

  QDate* fSelectedDate;

 void init();
  
public slots:
  /** Called whenever the Use Filter button is toggled
  */
  void slotUseFilterToggled(bool on);

  void slotCommandActivated(int);
  void slotFieldActivated(int);
  void slotDateSelected(QDate);
};

#endif
