#ifndef _MAIL_BOX_CONFIG_DLG_H_
#define _MAIL_BOX_CONFIG_DLG_H_

#include <qdialog.h>
#include <qlist.h>

#include "resource.h"

class QPushButton;
class QLabel;
class QLineEdit;
class QComboBox;
class QGroupBox;
class QCheckBox;
class QSpinBox;
class CAddDialog;

class CMailBoxConfigDlg : public QDialog
{
  Q_OBJECT

public:
  CMailBoxConfigDlg(QList<ServerStruct>* mailboxList, QWidget* parent, const char* name);
  ~CMailBoxConfigDlg();

  void writeOptions();

protected:
 

  QPushButton *fAdd;
  QPushButton *fDelete;

  QLabel  *fStaticServer;
  QLabel  *fStaticUserName;
  QLabel  *fStaticPassword;
  QLabel  *fStaticPort;
  QLabel  *fStaticNumMailBoxes;
  QLabel  *fNumMailBoxes;
  QLabel  *fStaticSavePassword;

  QComboBox *fServer;
  QComboBox *fServerType;

  QLineEdit *fUserName;
  QLineEdit *fPassword;
  QLineEdit *fFolder;   // For IMAP

  QSpinBox *fPort;

  QGroupBox *fInfoBox;

  QCheckBox *fSavePassword;

  CAddDialog* fAddDialog;
  
  ServerStruct* fServerInfo;

  QList<ServerStruct>* fMailboxList;

  void disableButtons();
  void enableButtons();
  /** Used to save the currently displayed mailbox if the user switches to a new one.
   * This makes sure everything they might update, like pass or username, is saved
   * even if they haven't hit the 'OK' button yet.
   */
  void writeServerInfo(int index = -1);
  void setGui(ServerStruct* serverInfo, int index = -1);

public slots:
  void slotAdd();
  void slotDelete();
  void slotComboActivated(int);
  void slotAddDialogOk();
  void  slotServerTypeChanged(int);
  

};

#endif;
