// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qlabel.h>

#include <kapp.h>

#include "messages.h"
#include "messages.moc"
#include "server.h"

SendMsg::SendMsg( QWidget* parent, const char* name )
  : QDialog( parent, name, TRUE, 0 )
{
  ml_message = new QMultiLineEdit( this, "MultiLineEdit_1" );
  ml_message->setGeometry( 24, 72, 304, 80 );
  ml_message->setMinimumSize( 10, 10 );
  ml_message->setMaximumSize( 32767, 32767 );
  ml_message->insertLine( "" );
  ml_message->setReadOnly( FALSE );
  ml_message->setOverwriteMode( FALSE );

  ml_message->setFocus();
  
  QLabel* dlgedit_Label_1;
  dlgedit_Label_1 = new QLabel( this, "Label_1" );
  dlgedit_Label_1->setGeometry( 16, 16, 248, 24 );
  dlgedit_Label_1->setAutoResize( TRUE );
  dlgedit_Label_1->setText( klocale->translate("Send message to:") );
  dlgedit_Label_1->setAlignment( 289 );
  dlgedit_Label_1->setMargin( -1 );
  
  l_receiver = new QLabel( this, "Label_2" );
  l_receiver->setGeometry( 24, 40, 304, 24 );
  l_receiver->setAutoResize( TRUE );
  l_receiver->setMinimumSize( 304, 24 );
  l_receiver->setText( "" );
  l_receiver->setAlignment( 289 );
  l_receiver->setMargin( -1 );
  
  b_ok = new QPushButton( this, "PushButton_1" );
  b_ok->setGeometry( 40, 176, 96, 24 );
  b_ok->setFixedSize( 96, 24 );
  b_ok->setText( klocale->translate("Ok") );
  b_ok->setAutoRepeat( FALSE );
  b_ok->setAutoResize( FALSE );
  
  b_cancel = new QPushButton( this, "PushButton_2" );
  b_cancel->setGeometry( 216, 176, 96, 24 );
  b_cancel->setFixedSize( 96, 24 );
  b_cancel->setText( klocale->translate("Cancel") );
  b_cancel->setAutoRepeat( FALSE );
  b_cancel->setAutoResize( FALSE );

  connect(b_ok, SIGNAL(clicked()), SLOT(accept()) );
  connect(b_cancel, SIGNAL(clicked()), SLOT(reject()) );
  
  resize( 352,224 );
  setMinimumSize( 352, 224 );
}


SendMsg::~SendMsg()
{
}

void SendMsg::resizeEvent( QResizeEvent *)
{
  b_ok->move(width()/4-b_ok->width()/2, height()-40);
  b_cancel->move(width()/2+width()/4-b_cancel->width()/2, height()-40);
  ml_message->resize(width() - 48, b_ok->y() - ml_message->y() - 16);
}

//----------------------------------------------------
//----------------------------------------------------

RecvMsg::RecvMsg( short wid, QWidget* parent, const char* name )
  : QDialog( parent, name, 0 )
{
  details = 0;

  ml_message = new QMultiLineEdit( this, "MultiLineEdit_1" );
  ml_message->setGeometry( 24, 88, 304, 84 );
  ml_message->setMinimumSize( 304, 84 );
  ml_message->setMaximumSize( 32767, 32767 );
  ml_message->insertLine( "" );
  ml_message->setReadOnly( TRUE );
  ml_message->setOverwriteMode( FALSE );
  
  QLabel* dlgedit_Label_3;
  dlgedit_Label_3 = new QLabel( this, "Label_3" );
  dlgedit_Label_3->setGeometry( 16, 16, 184, 24 );
  dlgedit_Label_3->setMinimumSize( 184, 24 );
  dlgedit_Label_3->setAutoResize(TRUE);
  dlgedit_Label_3->setText( klocale->translate("Received message from:") );
  dlgedit_Label_3->setAlignment( 289 );
  dlgedit_Label_3->setMargin( -1 );

  QLabel* dlgedit_Label_4;
  dlgedit_Label_4 = new QLabel( this, "Label_4" );
  dlgedit_Label_4->setGeometry( 16, 60, 184, 24 );
  dlgedit_Label_4->setMinimumSize( 184, 24 );
  dlgedit_Label_4->setText( klocale->translate("at:") );
  dlgedit_Label_4->setAlignment( 289 );
  dlgedit_Label_4->setMargin( -1 );

  l_date = new QLabel( this, "l_date" );
  l_date->setGeometry( 40, 60, 184, 24 );
  l_date->setMinimumSize( 184, 24 );
  l_date->setMaximumSize( 32767, 32767 );
  l_date->setText( "" );
  l_date->setAlignment( 289 );
  l_date->setMargin( -1 );
  
  l_receiver = new QLabel( this, "Label_2" );
  l_receiver->setGeometry( 24, 40, 304, 24 );
  l_receiver->setMinimumSize( 304, 24 );
  l_receiver->setAutoResize(TRUE);
  l_receiver->setText( "" );
  l_receiver->setAlignment( 289 );
  l_receiver->setMargin( -1 );
  
  b_details = new QPushButton( this, "PushButton_3" );
  b_details->setGeometry( 232, 16, 96, 24 );
  b_details->setFixedSize( 96, 24 );
  b_details->setText( klocale->translate("Details") );
  b_details->setAutoRepeat( FALSE );
  b_details->setAutoResize( FALSE );
  
  b_ok = new QPushButton( this, "PushButton_4" );
  b_ok->setGeometry( 48, 184, 96, 24 );
  b_ok->setFixedSize( 96, 24 );
  b_ok->setText( klocale->translate("Ok") );
  b_ok->setAutoRepeat( FALSE );
  b_ok->setAutoResize( FALSE );
  
  b_reply = new QPushButton( this, "PushButton_5" );
  b_reply->setGeometry( 216, 184, 96, 24 );
  b_reply->setFixedSize( 96, 24 );
  b_reply->setText( klocale->translate("Reply") );
  b_reply->setAutoRepeat( FALSE );
  b_reply->setAutoResize( FALSE );

  connect(b_ok, SIGNAL(clicked()), SLOT(okSlot()) );
  connect(b_details, SIGNAL(clicked()), SLOT(showDetails()) );
  connect(b_reply, SIGNAL(clicked()), SLOT(replySlot()) );
  win_id = wid;
  
  resize( 352,232 );
  setMinimumSize( 352, 232 );
}

RecvMsg::~RecvMsg()
{
  if( details )
    delete details;
}

void RecvMsg::resizeEvent( QResizeEvent *)
{
  b_ok->move(width()/4-b_ok->width()/2, height()-40);
  b_reply->move(width()/2+width()/4-b_reply->width()/2, height()-40);
  ml_message->resize(width() - 48, b_ok->y() - ml_message->y() - 16);
}

void RecvMsg::setInfo(const struct users *rec)
{
  user_data.id      = rec->user_id;
  user_data.name    = rec->name;
  user_data.fname   = rec->fname;
  user_data.nname   = rec->nname;
  user_data.date    = rec->date;
  user_data.email   = rec->email;
}

void RecvMsg::showDetails()
{
  if( !details )
    {
      details = new DetailsDialog;
      details->setInfo(&user_data);
      connect( details, SIGNAL(close()), this, SLOT(hideDetails()) );
      details->show();
    }
}

void RecvMsg::hideDetails()
{
  if( details )
    {
      delete details;
      details = 0;
    }
}

//----------------------------------------------------
//----------------------------------------------------

DetailsDialog::DetailsDialog( QWidget *parent, const char *name )
  : QDialog( parent, name, FALSE, 0 )
{
  l_name = new QLabel( this, "Label_5" );
  l_name->setGeometry( 120, 32, 240, 24 );
  l_name->setMinimumSize( 10, 10 );
  l_name->setMaximumSize( 32767, 32767 );
  l_name->setFrameStyle( 50 );
  l_name->setText( "" );
  l_name->setAlignment( 289 );
  l_name->setMargin( -1 );
  
  l_id = new QLabel( this, "Label_9" );
  l_id->setGeometry( 120, 160, 112, 24 );
  l_id->setMinimumSize( 10, 10 );
  l_id->setMaximumSize( 32767, 32767 );
  l_id->setFrameStyle( 50 );
  l_id->setText( "" );
  l_id->setAlignment( 289 );
  l_id->setMargin( -1 );
  
  l_email = new QLabel( this, "Label_10" );
  l_email->setGeometry( 120, 128, 240, 24 );
  l_email->setMinimumSize( 10, 10 );
  l_email->setMaximumSize( 32767, 32767 );
  l_email->setFrameStyle( 50 );
  l_email->setText( "" );
  l_email->setAlignment( 289 );
  l_email->setMargin( -1 );
  
  l_nname = new QLabel( this, "Label_11" );
  l_nname->setGeometry( 120, 96, 240, 24 );
  l_nname->setMinimumSize( 10, 10 );
  l_nname->setMaximumSize( 32767, 32767 );
  l_nname->setFrameStyle( 50 );
  l_nname->setText( "" );
  l_nname->setAlignment( 289 );
  l_nname->setMargin( -1 );
  
  l_fname = new QLabel( this, "Label_12" );
  l_fname->setGeometry( 120, 64, 240, 24 );
  l_fname->setMinimumSize( 10, 10 );
  l_fname->setMaximumSize( 32767, 32767 );
  l_fname->setFrameStyle( 50 );
  l_fname->setText( "" );
  l_fname->setAlignment( 289 );
  l_fname->setMargin( -1 );
  
  QLabel* dlgedit_Label_13;
  dlgedit_Label_13 = new QLabel( this, "Label_13" );
  dlgedit_Label_13->setGeometry( 16, 32, 100, 24 );
  dlgedit_Label_13->setMinimumSize( 10, 10 );
  dlgedit_Label_13->setMaximumSize( 32767, 32767 );
  dlgedit_Label_13->setText( "Name:" );
  dlgedit_Label_13->setAlignment( 290 );
  dlgedit_Label_13->setMargin( -1 );
  
  QLabel* dlgedit_Label_14;
  dlgedit_Label_14 = new QLabel( this, "Label_14" );
  dlgedit_Label_14->setGeometry( 16, 64, 96, 24 );
  dlgedit_Label_14->setMinimumSize( 10, 10 );
  dlgedit_Label_14->setMaximumSize( 32767, 32767 );
  dlgedit_Label_14->setText( "First name:" );
  dlgedit_Label_14->setAlignment( 290 );
  dlgedit_Label_14->setMargin( -1 );
  
  QLabel* dlgedit_Label_15;
  dlgedit_Label_15 = new QLabel( this, "Label_15" );
  dlgedit_Label_15->setGeometry( 16, 96, 100, 24 );
  dlgedit_Label_15->setMinimumSize( 10, 10 );
  dlgedit_Label_15->setMaximumSize( 32767, 32767 );
  dlgedit_Label_15->setText( "Nickname:" );
  dlgedit_Label_15->setAlignment( 290 );
  dlgedit_Label_15->setMargin( -1 );
  
  QLabel* dlgedit_Label_16;
  dlgedit_Label_16 = new QLabel( this, "Label_16" );
  dlgedit_Label_16->setGeometry( 12, 128, 104, 24 );
  dlgedit_Label_16->setMinimumSize( 10, 10 );
  dlgedit_Label_16->setMaximumSize( 32767, 32767 );
  dlgedit_Label_16->setText( "Email:" );
  dlgedit_Label_16->setAlignment( 290 );
  dlgedit_Label_16->setMargin( -1 );
  
  QLabel* dlgedit_Label_17;
  dlgedit_Label_17 = new QLabel( this, "Label_17" );
  dlgedit_Label_17->setGeometry( 16, 160, 100, 24 );
  dlgedit_Label_17->setMinimumSize( 10, 10 );
  dlgedit_Label_17->setMaximumSize( 32767, 32767 );
  dlgedit_Label_17->setText( "ID:" );
  dlgedit_Label_17->setAlignment( 290 );
  dlgedit_Label_17->setMargin( -1 );

  b_ok = new QPushButton( this, "PushButton_6" );
  b_ok->setGeometry( 152, 200, 96, 24 );
  b_ok->setMinimumSize( 10, 10 );
  b_ok->setMaximumSize( 32767, 32767 );
  b_ok->setText( "Ok" );
  b_ok->setAutoRepeat( FALSE );
  b_ok->setAutoResize( FALSE );

  connect( b_ok, SIGNAL(clicked()), SLOT(okSlot()) );
  
  resize( 400,240 );
  setMinimumSize( 400, 240 );
  setMaximumSize( 400, 240 );
}

DetailsDialog::~DetailsDialog()
{

}

void DetailsDialog::setInfo( User *user_data)
{
  QString id;
  id.setNum(user_data->id);
  l_id->setText(id);
  l_name->setText(user_data->name);
  l_fname->setText(user_data->fname);
  l_nname->setText(user_data->nname);
  l_email->setText(user_data->email);
}

void DetailsDialog::setInfo( unsigned long i, QString n, QString nn, QString fn, QString e)
{
  QString id;
  id.setNum(i);
  l_id->setText(id);
  l_name->setText(n);
  l_fname->setText(fn);
  l_nname->setText(nn);
  l_email->setText(e);
}



