#ifndef _COMMON_H_
#define _COMMON_H_

// New event definition, to include initiliazing in the application main event loop
#include <qevent.h>
#define	Event_Initialize	1001
class QInitEvent : public QEvent
{
public:
	QInitEvent(const char *_url) : QEvent(Event_Initialize), Url(_url) {}
	const char* url() const { return Url;}
protected:
	const char	*Url;
};

// Bookmark item definition
#include <qstring.h>
#define	BOOKMARK_MENU	0x01
#define	BOOKMARK_TOOL	0x02
struct BookmarkItem
{
	BookmarkItem(const char *url, const char *name = 0, int accelKey = 0, const char *_icon = 0, int status = BOOKMARK_MENU) : Bookmark(url), AccelKey(accelKey), IconName(_icon), Status(status)
	{ if (!name) Name = url; else Name = name;}
	BookmarkItem(const BookmarkItem& b) : Bookmark(b.Bookmark.data()), Name(b.Name.data()), AccelKey(b.AccelKey), IconName(b.IconName.data()), Status(b.Status) {}

	QString		Bookmark;
	QString		Name;
	int		AccelKey;
	QString		IconName;
	int		Status;
};

// Subwindow class definition
#include "fileview.h"
#include "KMDIMgrBase.h"
#include <qlist.h>
class FileWindow
{
public:
	FileWindow(FileViewWidget *view, int style, KMDIWindow *wnd = 0);
	~FileWindow();
	FileWindow(int style, FileWindow *wnd = 0);

	void setView(FileViewWidget *view, int style);
	void updateList(bool keepSel = false);
	void clearList();
	void setUrl(const char *url);

	FileViewWidget	*FileView;
	FileInfoList	*FileList;
	int		Style;
	KMDIWindow	*Window;
	QString		Url;
	int		Sorting;
	short		SortDirection;
	QString		TreePath;
	int		Index;
	bool		UpdateFlag;
};

typedef QList<FileWindow>	FileWindowList;
typedef QListIterator<FileWindow>	FileWindowListIterator;

// Option structure definition
#include "mystrlist.h"
struct KExplorer_options
{
	bool		UseKDEIcons;
	bool		UseKDEMimeTypes;
	bool		UseMagicNumbers;
	QString		IconPath;
	QString		MagicFile;
	QString		ExtensionFile;
	int		Style;
	int		Sorting;
	bool		ToolBarEnabled;
	bool		StatusBarEnabled;
	bool		ViewToolBarEnabled;
	bool		URLToolBarEnabled;
	int		URLToolBarStyle;
	bool		ShowHiddenFiles;
	int		SavedWidth;
	int		SavedHeight;
	int		SavedDirWidth;
	QString		ColName[16];
	MyStrList	ColType;
	MyStrList	ColWidth;
	int		DateFormat;
	bool		DetailSelectionMode;
	bool		ShowArchive;
	bool		ShowMiniImages;
	int		MiniImageSaving;
	int		ImageSize;
	QString		Shell;
	QString		LastPath;
	int		StartupDir;
	bool		MultipleView;
	int		WindowsCount;
	bool		AutoTile;
	int		ViewType;
	bool		DefaultEdit;
	QString		EditApplication;
	bool		PasswdSaving;
	bool		ImagePreview;
	int		ViewToolBarPosition;
	bool		TrackingEnabled;
	bool		SortingExtended;
	int		HistorySize;
	bool		ShowTreeView;
	bool		SingleClick;
	int		SambaVersion;
        bool            UseWINS;
        QString         WINS_Server;
        QString         WINS_IP;
	bool		TreeFollow;
	bool		AppsInSubMenu;
};

// some useful functions definitions
QString processForShell(const QString& str);	// implemented in smb.cc

#endif
