#include <iostream.h>
#include <unistd.h>
#include <kapp.h>
#include <qregexp.h>
#include <kiconloader.h>
#include <kpixmap.h>
#include "kpiconloader.h"

KPIconLoader::KPIconLoader(const QString& pathname, bool useKDE)
{
	Path.setAutoDelete(TRUE);
	KDEPath.setAutoDelete(TRUE);
	QString	*localkdedir = new QString(KApplication::localkdedir());
	(*localkdedir) += "/share/icons/";
	KDEPath.append(localkdedir);
	QString	*kdedir = new QString(KApplication::kde_icondir() + "/");
	KDEPath.append(kdedir);
	setupPath(useKDE,pathname);
	Icons.setAutoDelete(TRUE);
	Icons.insert("nulPixmap",new QPixmap);
}

QPixmap* KPIconLoader::loadIcon(const QString& name, const QString& def)
{
	return loadInternal(name,def,0);
}

QPixmap* KPIconLoader::loadKDEIcon(const QString& name)
{
	return loadInternal(name,"",2);
}

QPixmap* KPIconLoader::loadMiniIcon(const QString& name, const QString& def)
{
	return loadInternal(name,def,1);
}

QPixmap* KPIconLoader::loadToolBarIcon(const QString& name)
{
	return loadInternal(name,"",3);
}

void KPIconLoader::reloadIcons(bool useKDE, const QString& str)
{
	QDictIterator<QPixmap>	itp(Icons);
	setupPath(useKDE,str);
	for ( ; itp.current(); ++itp) {
		if (strncmp(itp.currentKey(),"toolbar",7) == 0 || strcmp(itp.currentKey(),"nulPixmap") == 0 || strncmp(itp.currentKey(),"kde",3) == 0) continue;
		*(itp.current()) = changeIcon(itp.currentKey());
	}
}

QPixmap KPIconLoader::changeIcon(const char *name)
{
	QString		path = getIconPathInternal((UseKDE ? KDEPath : Path),name,"");
	KPixmap		pixmap;
	if (!path.isEmpty()) pixmap.load(path.data(),0L,KPixmap::LowColor);
	else return *(Icons.find("nulPixmap"));
	return pixmap;
}

void KPIconLoader::setupPath(bool useKDE, const QString& pathname)
{
	UseKDE = useKDE;
	QString		tmp(pathname.data());
	char *c = strtok(tmp.data(),";");
	Path.clear();
	while (c != 0) {
		QString		*tmp = new QString(c);
		if (tmp->right(1) != "/") tmp->append("/");
		Path.append(tmp);
		c = strtok(0,";");
	}
	// now setting up KIconLoader so that it can be used for mini icons
	kapp->getIconLoader()->getDirList()->clear();
	QListIterator<QString>	it((UseKDE ? KDEPath : Path));
	for (int i=0;it.current();++it,i++)
		kapp->getIconLoader()->insertDirectory(i,*(it.current()) + "/mini");
}

QString KPIconLoader::getIconPathInternal(const QList<QString>& list, const QString& icon, const QString& prefix)
{
	QListIterator<QString>	it(list);
	QString		path;
	for (;it.current();++it) {
		path = *(it.current()) + prefix + icon;
		if (::access(path.data(),F_OK | R_OK) == 0) return path;
	}
	return "";
}

QString KPIconLoader::getKey(const QString& icon, int flag)
{
	QString		key;
	switch (flag) {
	   case 0: key = icon.data(); break;
	   case 1: key = "mini/" + icon; break;
	   case 2: key = "kde/" + icon; break;
	   case 3: key = "toolbar/" + icon; break;
	}
	return key;
}

QString KPIconLoader::getIconPath(const QString& icon, int flag)
{
	switch (flag) {
	   case 0:
	   case 1: return getIconPathInternal((UseKDE ? KDEPath : Path),icon,(flag == 0 ? "" : "/mini/"));
	   case 2: return getIconPathInternal(KDEPath,icon,"/mini/");
	   case 3:
 		{
			QString	str = KApplication::kde_datadir() + "/kruiser/icons/toolbar/" + icon;
			if (::access(str.data(),F_OK | R_OK) == 0) return str;
			else return "";
		}
	}
	return "";
}

QPixmap* KPIconLoader::loadInternal(const QString& icon, const QString& def, int flag)
{
	QPixmap		*iconpix = 0;
	KPixmap		kpix;
	if ((iconpix=Icons.find(getKey(icon,flag).data())) != 0) return iconpix;
	QString		path = getIconPath(icon,flag);
	if (!path.isEmpty()) {
		kpix.load(path.data(),0L,KPixmap::LowColor);
		if (!kpix.isNull()) {
			iconpix = new QPixmap(kpix);
			Icons.insert(getKey(icon,flag).data(),iconpix);
			return iconpix;
		}
	}
	if (!def.isEmpty()) return loadInternal(def,"",flag);
	else return Icons.find("nulPixmap");
}
