#include "ktreedialog.h"
#include <qpushbutton.h>
#include <qheader.h>
#include <qobjectlist.h>
#include <iostream.h>

void TreeWidget::resizeEvent(QResizeEvent *)
{
	// find current shown children widget
	QObjectList	*list = queryList(0,0,false,false);
	QObject	*obj = list->first();
	while (obj) {
		if (obj->isWidgetType() && ((QWidget*)obj)->isVisible()) break;
		obj = list->next();
	}
	delete list;
if (obj) cout << "found : " << obj->className() << endl;
	// if found, adjust its geometry
	if (obj) ((QWidget*)obj)->setGeometry(0,0,width(),height());
}

KTreeDialog::KTreeDialog(QWidget *parent, const char *name, bool modal, WFlags f)
	: QDialog(parent,name,modal,f)
{
	Panner = new QSplitter(this);
	TreeList = new QListView(Panner);
	TreeList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	TreeList->setLineWidth(2);
	TreeList->addColumn("Root");
	TreeList->header()->hide();
	TreeList->setSorting(-1);
	TreeList->resize(100,100);
	MainView = new TreeWidget(Panner);
	MainView->resize(300,100);
	WidgetList.setAutoDelete(false);
	Ok = Cancel = Apply = 0;
	Root = new TreeListItem(TreeList,"Root");
	Root->setOpen(true);
	CurrentWidget = 0;
	Last = 0;
	connect(TreeList,SIGNAL(selectionChanged(QListViewItem*)),SLOT(selectionChanged(QListViewItem*)));
	ItemList.setAutoDelete(false);
}

KTreeDialog::~KTreeDialog()
{
}

void KTreeDialog::resizeEvent(QResizeEvent*)
{
//	int	w = width()/4;
	int	h(0);
	if (Ok || Cancel || Apply) h = 40;
	Panner->setGeometry(0,0,width(),height()-h);
//	TreeList->setGeometry(0,0,w,height());
//	TreeList->setColumnWidth(0,w-4);
//	MainView->setGeometry(w,0,width()-w,height()-h);
//	if (CurrentWidget) CurrentWidget->setGeometry(0,0,MainView->width(),MainView->height());
	int	count = 1;
	if (Cancel) {
		Cancel->setGeometry(width()-count*85,height()-35,80,30);
		count++;
	}
	if (Apply) {
		Apply->setGeometry(width()-count*85,height()-35,80,30);
		count++;
	}
	if (Ok) {
		Ok->setGeometry(width()-count*85,height()-35,80,30);
		count++;
	}
}

void KTreeDialog::setOkButton(const char *text)
{
	Ok = new QPushButton(text,this);
	connect(Ok,SIGNAL(clicked()),SLOT(accept()));
	connect(Ok,SIGNAL(clicked()),SIGNAL(applyButtonPressed()));
}

void KTreeDialog::setApplyButton(const char *text)
{
	Apply = new QPushButton(text,this);
	connect(Apply,SIGNAL(clicked()),SIGNAL(applyButtonPressed()));
}

void KTreeDialog::setCancelButton(const char *text)
{
	Cancel = new QPushButton(text,this);
	connect(Cancel,SIGNAL(clicked()),SLOT(reject()));
}

void KTreeDialog::addTab(QWidget *w, const char *name)
{
  addSubTab(w,name,0);
}

void KTreeDialog::addSubTab(QWidget *w, const char *name, const char *parent)
{
  // first find the parent
  QListIterator<TreeListItem> it(ItemList);
  for (;it.current();++it) if (strcmp(it.current()->text(0),parent) == 0) break;
  TreeListItem *Parent = (it.current() ? it.current() : Root);
  // then find the last item in the parent
  TreeListItem *LastItem = (TreeListItem*)(Parent->firstChild());
  while (LastItem && LastItem->nextSibling()) LastItem = (TreeListItem*)(LastItem->nextSibling());
  // finally create the new item
  TreeListItem *item;
  if (LastItem) item = new TreeListItem(Parent,LastItem,w,name);
  else item = new TreeListItem(Parent,w,name);
  Last = item;
  ItemList.append(item);
  if (w) 
    {
      WidgetList.append(w);
      w->recreate(MainView,0,QPoint(0,0),false);
      w->hide();
    }
}

void KTreeDialog::selectionChanged(QListViewItem *it)
{
	if (CurrentWidget) CurrentWidget->hide();
	CurrentWidget = ((TreeListItem*)it)->widget();
	if (CurrentWidget) {
		CurrentWidget->setGeometry(0,0,MainView->width(),MainView->height());
		CurrentWidget->show();
	}
}

void KTreeDialog::setRootText(const char *text)
{
	Root->setText(0,text);
}
