#include <kapp.h>
#include <kfiledialog.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <kstatusbar.h>
#include <kslider.h>
#include <kstdaccel.h>
#include <kintegerline.h>

#include <qmultilinedit.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qframe.h>
#include <qfont.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <drag.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/stat.h>

#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <string.h>
#include <time.h>

#include "kfilter.moc"
#include "kifstats.h"
#include "kportstats.h"
#include "options.h"
#include "dirs.h"


PortFilterModal::PortFilterModal(QWidget *parent, const char *name)
  :QDialog(parent, name, TRUE)
{
  QRect parentrect;
  ports=NULL;

  hitcancel=0;

  parentrect = parent->frameGeometry();

  //this->setGeometry(150, 150, 230, 200);
  this->setGeometry(parentrect.left(), parentrect.top(),350, 300 );
  textLabel = new QLabel(this, "Interface");
  textLabel->setText("Add/Delete a port or range");
  textLabel->setGeometry(50,5,200,15);

  //Setup listview area for available list of ports/ranges
  mylistview = new QListView(this, "PortListView");
  mylistview->addColumn("Min",-1);
  mylistview->addColumn("Max",-1);
  //mylistview->addColumn("Name",-1);
  mylistview->setGeometry(10,50,160,200);
  mylistview->setMultiSelection(TRUE);
  mylistview->setColumnWidth(0,50);
  mylistview->setColumnWidth(1,50);
 // mylistview->setColumnWidth(2,60);


  //Setup Edit areas
  portLabel = new QLabel(this, "Enter a Port or Range");
  portLabel->setText("Enter a port or range to Add");
  portLabel->setGeometry(180,50,200,15);

  minLabel = new QLabel(this, "Min");
  minLabel->setText("Min");
  minLabel->setGeometry(180,70,30,15);
  maxLabel = new QLabel(this, "Max");
  maxLabel->setText("Max");
  maxLabel->setGeometry(260,70,30,15);

//  nameLabel = new QLabel(this, "Name");
//  nameLabel->setText("Name for Port");
//  nameLabel->setGeometry(210,120,80,15);

  minEdit = new KIntegerLine(this, "Min", KEditTypeDec);
  minEdit->setGeometry(180,90,60,20);
  maxEdit = new KIntegerLine(this, "Max", KEditTypeDec);
  maxEdit->setGeometry(260,90,60,20);

  //nameEdit = new QLineEdit(this, "Name");
  //nameEdit->setGeometry(210,140,80,20);
  

  //Create the Add Button
  addButton = new QPushButton( "Add", this );
  addButton->setGeometry( 180,200,70,30 );
  connect( addButton, SIGNAL(clicked()), SLOT(add()));

  //Create the Delete Button
  delButton = new QPushButton( "Delete", this );
  delButton->setGeometry( 260,200,70,30 );
  connect( delButton, SIGNAL(clicked()), SLOT(del()));
  

  //Create our OK button
  ok = new QPushButton( "Ok", this );
  ok->setGeometry( 80,260,50,30 );
  connect( ok, SIGNAL(clicked()), SLOT(accept()));

  //Create the Cancel Button
  cancelButton = new QPushButton( "Cancel", this );
  cancelButton->setGeometry( 150,260,70,30 );
  connect( cancelButton, SIGNAL(clicked()), SLOT(reject()));


  this->loadaddports(&ports);
}

/************************************
 accept():
	User Selected "Ok" Button. 
 	So save the list to disk and
	close the dialog.
************************************/
void
PortFilterModal::accept()
{
 saveportlist(ports);
 destroyporttab(ports);
 this->close();
}


/************************************
 reject():
	User Selected "Cancel" Button. 
 	So, close the dialog.
************************************/
void
PortFilterModal::reject()
{
  destroyporttab(ports);
  hitcancel=1;	//let app know we canceled, so don't reset 
  this->close();
}

/************************************
 add():
	User Selected "Add" Button. 
 	So, add the port or range to
 	the list to be saved.
	Hitting "OK" Button saves list
	to disk.
************************************/
void
PortFilterModal::add()
{
//this->addports(&ports, ptemp->port_min, ptemp->port_max);

  if (minEdit->value() > 1024)
    {
     this->addports(&ports,minEdit->value(), maxEdit->value()); 
     minEdit->setValue(0);
     maxEdit->setValue(0);
    }
  else
   {
     KMsgBox *mybox;
     mybox = new KMsgBox(this, "Error", "Enter something to add!", 2,"ok",0,0,0);
     mybox->show();
     delete(mybox);
   }
}

/************************************
 del():
	User Selected "Delete" Button. 
 	So, Delete the selected entry
	in the list.  
	Hitting "Ok" button saves list
	to disk.
************************************/
void
PortFilterModal::del()
{
  int done=0;
  struct porttab *ptemp = NULL;

  ptemp = ports;

  while((ptemp != NULL) & !done)
     {
       if (ptemp->listviewitem->isSelected())
         {
           done=1;
           this->delport(&ports, ptemp);
         }
       else
           ptemp = ptemp->next_entry;
     } 

  if (!done)
    {
     KMsgBox *mybox;
     mybox = new KMsgBox(this, "Error", "Select something to delete!", 2,"ok",0,0,0);
     mybox->show();
     delete(mybox);
    }
}

/************************************
 loadaddports():
  	Load all the ports saved in
	the ports file, and then
	show them in the dialog.
************************************/
void 
PortFilterModal::loadaddports(struct porttab **table)
{
    int fd;
    struct porttab *ptemp;
    struct porttab *tail = NULL;
    int br;
    QString *tmpstr;

    *table = NULL;
  
    tmpstr = new QString();

//    fd = open(PORTFILE, O_RDONLY);
    fd = open(PORTS_FILE, O_RDONLY);
    if (fd < 0)
      {
        //If we close the file we crash!!  why?
        //close(fd);
	return;
      }

    do {
	ptemp = (struct porttab *)malloc(sizeof(struct porttab));

	br = read(fd, &(ptemp->port_min), sizeof(unsigned int));
	br = read(fd, &(ptemp->port_max), sizeof(unsigned int));

	if (br < 0) {
            //errbox("Error reading port list", ANYKEY_MSG, &resp);
            {
              KMsgBox *mybox;
              mybox = new KMsgBox(this, "Error", "Error reading Port list.  It must be corrupt.  Please delete it!", 2,"ok",0,0,0);
              mybox->show();
              delete(mybox);
            }
	    close(fd);
	    this->destroyporttab(*table);
	    return;
	}
	if (br > 0) {
	    if (*table == NULL) {
		*table = ptemp;
		ptemp->prev_entry = NULL;
	    }
	    if (tail != NULL) {
		tail->next_entry = ptemp;
		ptemp->prev_entry = tail;
	    }
	    tail = ptemp;
	    ptemp->next_entry = NULL;

	    //Add list to View
	    ptemp->listviewitem = new QListViewItem(mylistview);
            tmpstr->setNum(ptemp->port_min);
            ptemp->listviewitem->setText(0,tmpstr->data()); 
            tmpstr->setNum(ptemp->port_max);
            ptemp->listviewitem->setText(1,tmpstr->data());  
	} else {
	    free(ptemp);
        } 
    } while (br > 0);

    delete (tmpstr);

//Closing this crashes!! why?
//    close(fd); 
}


/************************************
 destroyporttab():
	This deletes the link list of
	ports.  
************************************/
void 
PortFilterModal::destroyporttab(struct porttab *table)
{
    struct porttab *ptemp = table;
    struct porttab *ctemp = NULL;

    if (ptemp != NULL)
	ctemp = ptemp->next_entry;

    while (ptemp != NULL) {
	free(ptemp);
	ptemp = ctemp;

	if (ctemp != NULL)
	    ctemp = ctemp->next_entry;
    }
}


/************************************
 delport():
	This deletes a specific entry
	in the port list.
************************************/
void 
PortFilterModal::delport(struct porttab **table, struct porttab *ptmp)
{
    if (ptmp != NULL) {
	if (ptmp == *table) {
	    *table = (*table)->next_entry;
	    if (*table != NULL)
		(*table)->prev_entry = NULL;
	} else {
	    ptmp->prev_entry->next_entry = ptmp->next_entry;

	    if (ptmp->next_entry != NULL)
		ptmp->next_entry->prev_entry = ptmp->prev_entry;
	}
        delete(ptmp->listviewitem);
	free(ptmp);
    }
}


/************************************
 addports():
 	This adds a port/range to the
	current list.  It first 
	checks to make sure the port
	or range isn't already in the
	list.
************************************/
void
PortFilterModal::addports(struct porttab **table, unsigned int port_min, unsigned int port_max)
{
    struct porttab *ptmp;
    QString *tmpstr;

    tmpstr = new QString();

	if (dup_portentry(*table, port_min, port_max))
	  {
	  //  errbox("Duplicate port/range entry", ANYKEY_MSG, &resp);
            {
              KMsgBox *mybox;
              mybox = new KMsgBox(this, "Error", "You entered a Port already in the list!", 2,"ok",0,0,0);
              mybox->show();
              delete(mybox);
            }
            fprintf(stderr, "Duplicate port/range entry\n");
          }
	else {
	    ptmp = (struct porttab *)malloc(sizeof(struct porttab));

	    ptmp->port_min = port_min;
	    ptmp->port_max = port_max;
	    ptmp->prev_entry = NULL;
	    ptmp->next_entry = *table;

	    if (*table != NULL)
		(*table)->prev_entry = ptmp;

	    *table = ptmp;
	    ptmp->listviewitem = new QListViewItem(mylistview);
            tmpstr->setNum(ptmp->port_min);
            ptmp->listviewitem->setText(0,tmpstr->data()); 
            tmpstr->setNum(ptmp->port_max);
            ptmp->listviewitem->setText(1,tmpstr->data());  
//	    saveportlist(*table);
	}
   delete(tmpstr);
}

/************************************
 saveportlist():
	This function saves the entire
	port/range list to disk.
************************************/
void 
PortFilterModal::saveportlist(struct porttab *table)
{
    struct porttab *ptmp = table;
    int fd;
    int bw;

    fd = open(PORTS_FILE, O_WRONLY | O_TRUNC | O_CREAT, S_IRUSR | S_IWUSR);

    if (fd < 0) {
//	errbox("Unable to open port list file", ANYKEY_MSG, &resp);
        {
          KMsgBox *mybox;
          mybox = new KMsgBox(this, "Error", "Unable to Open Port List file.", 2,"ok",0,0,0);
          mybox->show();
          delete(mybox);
        }
        close(fd);
	return;
    }
    while (ptmp != NULL) {
	bw = write(fd, &(ptmp->port_min), sizeof(unsigned int));
	bw = write(fd, &(ptmp->port_max), sizeof(unsigned int));
	
	if (bw < 0) {
//	    errbox("Unable to write port/range entry", ANYKEY_MSG, &resp);
            {
             KMsgBox *mybox;
             mybox = new KMsgBox(this, "Error", "Unable to write port entry.", 2,"ok",0,0,0);
             mybox->show();
             delete(mybox);
            }
	    destroyporttab(table);
	    close(fd);
	    return;
	}
	
	ptmp = ptmp->next_entry;
    }

    close(fd);
}

/************************************
 dup_portentry():
	This function saves the entire
	port/range list to disk.
************************************/
int 
PortFilterModal::dup_portentry(struct porttab *table, unsigned int min, unsigned int max)
{
    struct porttab *ptmp = table;

    while (ptmp != NULL) {
	if ((ptmp->port_min == min) && (ptmp->port_max == max))
	    return 1;

	ptmp = ptmp->next_entry;
    }
    return 0;
}
