
#include <kmsgbox.h>
#include <kstdaccel.h>
#include <kslider.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>

#include <qdialog.h>
#include <qtabdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qfont.h>
#include <qpainter.h>
#include <qspinbox.h>
#include <qmultilinedit.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <qcombo.h>
#include <qlistbox.h>
#include <qgrpbox.h>
#include <qkeycode.h>
#include <qslider.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qtooltip.h>
#include <qbttngrp.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <netdb.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>

#include "koptions.moc"
#include "options.h"
#include "kiface.h"
#include "kfilter.h"
#include "kifstats.h"
#include "version.h"

#include <kspinbox.h>
#include <kfiledialog.h>
#include <kapp.h> 

extern void srpromisc(int mode);
extern KSimpleConfig *config;

OptionsModal::OptionsModal( QWidget *parent, const char *name, struct OPTIONS *appoptions )
   :QTabDialog(parent, name, true)

{
//  QRect parentrect;
//  parentrect = parent->frameGeometry();
//  this->setGeometry(parentrect.left(), parentrect.top(),300, 300 );
//  optionsmodalparent = parent;
  
  options = appoptions;


  setCaption("Ksniffer Preferences");
  addTab( global(), "App prefs");
  addTab( gen(), "General Stats");
  addTab( det(), "Detailed Stats");
  addTab( prt(), "Port Stats");


  setCancelButton( "&Cancel" );
  connect( this, SIGNAL(cancelButtonPressed()), SLOT(reject()) );

  setOkButton( "&Ok" );
  connect( this, SIGNAL(applyButtonPressed()), SLOT(accept()) ); 
  this->resize(300,300);
}


QWidget *OptionsModal::global()
{
  QWidget *base = new QWidget( this, "App options" );

  QBoxLayout *l = new QVBoxLayout(base, 10, 0);

  QGroupBox *gb = new QGroupBox(base);
  gb->setTitle("Select Rate Display"); 

  QBoxLayout *l1 = new QVBoxLayout(gb, 10, 0);

  l1->addSpacing(10);

  ratebits = new QCheckBox(gb, "kbits");
  ratebits->setText("kbits/sec");
  ratebits->setMinimumSize(ratebits->sizeHint());
  l1->addWidget(ratebits);

  ratebytes = new QCheckBox(gb, "bytes");
  ratebytes->setText("kbytes/sec");
  ratebytes->setMinimumSize(ratebytes->sizeHint());
  l1->addWidget(ratebytes);

  if (options->actmode == KBITS)
    ratebits->setChecked(1);
  else ratebytes->setChecked(1);

  mybuttongroup = new QButtonGroup("Rate Display", base, "Rate Button Group");
  
  mybuttongroup->hide();
  mybuttongroup->insert(ratebits, 0);
  mybuttongroup->insert(ratebytes, 1);
  mybuttongroup->setExclusive(TRUE);

  l->addWidget(gb);

  l->addSpacing(10);

  promisc = new QCheckBox(base, "Promiscuous mode");
  promisc->setText("Promiscuous Mode (root only)");
  promisc->setMinimumSize(promisc->sizeHint());
  promisc->setChecked(options->promisc);
  l->addWidget(promisc);

  l->addStretch(1);
  l->activate();
  return base;  
}


QWidget *OptionsModal::gen()
{
  QWidget *base = new QWidget( this, "General Stats" );

  QBoxLayout *l = new QVBoxLayout(base, 10, 0);

  QGroupBox *gb = new QGroupBox(base);
  gb->setTitle("Select Columns to Display"); 

  QBoxLayout *l1 = new QVBoxLayout(gb, 10, 0);
  l1->addSpacing(10);

  genbox[0] = new QCheckBox(gb, "Total");
  genbox[0]->setText("Total Packet Count");
  genbox[0]->setMinimumSize(genbox[0]->sizeHint());
  genbox[0]->setChecked(options->genopts.total);
  l1->addWidget(genbox[0]);

  genbox[1] = new QCheckBox(gb, "Total IP");
  genbox[1]->setText("IP Packet Count");
  genbox[1]->setMinimumSize(genbox[1]->sizeHint());
  genbox[1]->setChecked(options->genopts.total_ip);
  l1->addWidget(genbox[1]);

  genbox[2] = new QCheckBox(gb, "Total NON-IP");
  genbox[2]->setText("NON-IP Packet Count");
  genbox[2]->setMinimumSize(genbox[2]->sizeHint());
  genbox[2]->setChecked(options->genopts.non_ip);
  l1->addWidget(genbox[2]);

  genbox[3] = new QCheckBox(gb, "Total IP");
  genbox[3]->setText("Bad Packet Count");
  genbox[3]->setMinimumSize(genbox[3]->sizeHint());
  genbox[3]->setChecked(options->genopts.bad_ip);
  l1->addWidget(genbox[3]);

  genbox[4] = new QCheckBox(gb, "Total IP");
  genbox[4]->setText("Activity (bandwidth usage)");
  genbox[4]->setMinimumSize(genbox[4]->sizeHint());
  genbox[4]->setChecked(options->genopts.activity);
  l1->addWidget(genbox[4]);

  l->addWidget(gb);

  l->addStretch(1);
  l->activate();
  return base;  

}


QWidget *OptionsModal::det()
{

  QWidget *base = new QWidget( this, "General Stats" );

  QBoxLayout *l = new QVBoxLayout(base, 10, 0);

  QGroupBox *gb = new QGroupBox(base);
  gb->setTitle("Select Columns to Display"); 

  QBoxLayout *l1 = new QVBoxLayout(gb, 10, 0);
  l1->addSpacing(10);

  detbox[0] = new QCheckBox(gb, "Total");
  detbox[0]->setText("Total Packet Count");
  detbox[0]->setMinimumSize(detbox[0]->sizeHint());
  detbox[0]->setChecked(options->detopts.pkts);
  l1->addWidget(detbox[0]);

  detbox[1] = new QCheckBox(gb, "Total Bytes Received");
  detbox[1]->setText("Byte Count");
  detbox[1]->setMinimumSize(detbox[1]->sizeHint());
  detbox[1]->setChecked(options->detopts.bytes);
  l1->addWidget(detbox[1]);

  detbox[2] = new QCheckBox(gb, "Activity");
  detbox[2]->setText("Activity (bandwidth usage)");
  detbox[2]->setMinimumSize(detbox[2]->sizeHint());
  detbox[2]->setChecked(options->detopts.activity);
  l1->addWidget(detbox[2]);

  l->addWidget(gb);

  l->addStretch(1);
  l->activate();
  return base;
}


QWidget *OptionsModal::prt()
{

  QWidget *base = new QWidget( this, "General Stats" );

  QBoxLayout *l = new QVBoxLayout(base, 10, 0);

  QGroupBox *gb = new QGroupBox(base);
  gb->setTitle("Select Columns to Display"); 

  QBoxLayout *l1 = new QVBoxLayout(gb, 10, 0);
  l1->addSpacing(10);

  prtbox[0] = new QCheckBox(gb, "Total");
  prtbox[0]->setText("Total Packet Count");
  prtbox[0]->setMinimumSize(prtbox[0]->sizeHint());
  prtbox[0]->setChecked(options->portopts.pkts);
  l1->addWidget(prtbox[0]);

  prtbox[1] = new QCheckBox(gb, "Total Bytes Received");
  prtbox[1]->setText("Byte Count");
  prtbox[1]->setMinimumSize(prtbox[1]->sizeHint());
  prtbox[1]->setChecked(options->portopts.bytes);
  l1->addWidget(prtbox[1]);

  prtbox[2] = new QCheckBox(gb, "Total Packets Sent");
  prtbox[2]->setText("Packets Sent Count");
  prtbox[2]->setMinimumSize(prtbox[2]->sizeHint());
  prtbox[2]->setChecked(options->portopts.pkts_to);
  l1->addWidget(prtbox[2]);

  prtbox[3] = new QCheckBox(gb, "Total Bytes Sent");
  prtbox[3]->setText("Bytes Sent Count");
  prtbox[3]->setMinimumSize(prtbox[3]->sizeHint());
  prtbox[3]->setChecked(options->portopts.bytes_to);
  l1->addWidget(prtbox[3]);

  prtbox[4] = new QCheckBox(gb, "Total Packets Received");
  prtbox[4]->setText("Packets Received Count");
  prtbox[4]->setMinimumSize(prtbox[4]->sizeHint());
  prtbox[4]->setChecked(options->portopts.pkts_from);
  l1->addWidget(prtbox[4]);

  prtbox[5] = new QCheckBox(gb, "Total Bytes Received");
  prtbox[5]->setText("Bytes Received Count");
  prtbox[5]->setMinimumSize(prtbox[5]->sizeHint());
  prtbox[5]->setChecked(options->portopts.bytes_from);
  l1->addWidget(prtbox[5]);

  prtbox[6] = new QCheckBox(gb, "Activity (bandwidth usage)");
  prtbox[6]->setText("Activity (bandwidth usage)");
  prtbox[6]->setMinimumSize(prtbox[6]->sizeHint());
  prtbox[6]->setChecked(options->portopts.activity);
  l1->addWidget(prtbox[6]);


/*  detbox[2] = new QCheckBox(gb, "Activity");
  detbox[2]->setText("Activity (bandwidth usage)");
  detbox[2]->setMinimumSize(detbox[2]->sizeHint());
  l1->addWidget(detbox[2]);
*/

  l->addWidget(gb);

  l->addSpacing(10);

  servnames = new QCheckBox(base, "Service Names");
  servnames->setText("Display port names, not Number's");
  servnames->setMinimumSize(servnames->sizeHint());
  servnames->setChecked(options->servnames);

  l->addWidget(servnames);
  l->addStretch(1);
  l->activate();
  return base;  
}

void
OptionsModal::accept()
{
  //Ok save our prefs to disk

  //First save app level prefs
  config->setGroup("Global");
  config->writeEntry("Promisc", promisc->isChecked());
  options->promisc = promisc->isChecked();
  config->writeEntry("Actmode", !ratebits->isChecked());
  options->actmode = !ratebits->isChecked();

  //Ok Save General Stats to disk
  config->setGroup("General");
  config->writeEntry("total", genbox[0]->isChecked());
  options->genopts.total = genbox[0]->isChecked();
  config->writeEntry("total_ip", genbox[1]->isChecked());
  options->genopts.total_ip = genbox[1]->isChecked();
  config->writeEntry("non_ip", genbox[2]->isChecked());
  options->genopts.non_ip = genbox[2]->isChecked();
  config->writeEntry("bad_ip", genbox[3]->isChecked());
  options->genopts.bad_ip = genbox[3]->isChecked();
  config->writeEntry("activity", genbox[4]->isChecked());
  options->genopts.activity = genbox[4]->isChecked();

  //Save Detailed stats prefs to disk
  config->setGroup("Detailed");
  config->writeEntry("pkts", detbox[0]->isChecked());
  options->detopts.pkts = detbox[0]->isChecked();
  config->writeEntry("bytes", detbox[1]->isChecked());
  options->detopts.bytes = detbox[1]->isChecked();
  config->writeEntry("activity", detbox[2]->isChecked());
  options->detopts.activity = detbox[2]->isChecked();

  config->setGroup("Port");
  config->writeEntry("servnames", servnames->isChecked());
  options->servnames = servnames->isChecked();
  config->writeEntry("pkts", prtbox[0]->isChecked());
  options->portopts.pkts = prtbox[0]->isChecked();
  config->writeEntry("bytes", prtbox[1]->isChecked());
  options->portopts.bytes = prtbox[1]->isChecked();
  config->writeEntry("pkts_to", prtbox[2]->isChecked());
  options->portopts.pkts_to = prtbox[2]->isChecked();
  config->writeEntry("bytes_to", prtbox[3]->isChecked());
  options->portopts.bytes_to = prtbox[3]->isChecked();
  config->writeEntry("pkts_from", prtbox[4]->isChecked());
  options->portopts.pkts_from = prtbox[4]->isChecked();
  config->writeEntry("bytes_from", prtbox[5]->isChecked());
  options->portopts.bytes_from = prtbox[5]->isChecked();
  config->writeEntry("activity", prtbox[6]->isChecked());
  options->portopts.activity = prtbox[6]->isChecked();

  //flush to disk
  config->sync();

  if (promisc->isChecked())
      srpromisc(1);
  else 
     srpromisc(0);

 done(1);
}

void
OptionsModal::reject()
{
 done(0);
}
