#ifndef KOPTDLG_H
#define KOPTDLG_H

#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kslider.h>
#include <qmultilinedit.h>
#include <drag.h>
#include <qdialog.h>
#include <qtabdialog.h>
#include <qframe.h>
#include <qimage.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include "kifstats.h"
#include "kportstats.h"
#include "options.h"

class OptionsModal : public QTabDialog
 {
   Q_OBJECT;

   private:
    QPushButton *ok, *cancelButton;
    QLabel *textLabel;
    QWidget *optionsmodalparent;
    QButtonGroup *mybuttongroup;
    struct OPTIONS *options;

    QWidget *global();
    QWidget *gen();
    QWidget *det();
    QWidget *prt();

   public:
    QCheckBox *ratebits, *ratebytes;
    QCheckBox *promisc, *servnames;
    QCheckBox *genbox[5];		//check box for general stats hdr
    QCheckBox *detbox[3];		//check box for detailed stats hdr
    QCheckBox *prtbox[7];		//check box for port stats hdr
    OptionsModal( QWidget *parent, const char *name, struct OPTIONS *appoptions);

   public slots:
   void accept();  //user clicked ok
   void reject();  //user clicked cancel
};
#endif
