#include <qkeycode.h>

#include <kmsgbox.h>
#include <kstdaccel.h>
#include <kslider.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>
#include <kwm.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qfont.h>
#include <qpainter.h>
#include <qspinbox.h>
#include <qmultilinedit.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <netdb.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>

#include "ksniffer.moc"
#include "kiface.h"
#include "kfilter.h"
#include "kifstats.h"
#include "koptions.h"
#include "version.h"

KSimpleConfig *config;

extern void srpromisc(int mode);

#define CONFIG_FILE QString(KApplication::localconfigdir() + "/ksnifferrc")

//This is the main constructor for the app
KSniffer::KSniffer ()
{

   //Set the size of this box to 480x320 @ 300,300
  // this->setGeometry(300,300,480,320);
   this->resize(480,320);

  /**
    We'll get the statdard KDE accelerator key combinations from this.
    */

  KStdAccel *kkeys=new KStdAccel (kapp->getConfig());

  /**
    Create the pulldown menus for the menubar.
    */
  file = new QPopupMenu();
  CHECK_PTR(file);
  file->insertItem (i18n("&Options"), this, SLOT (slotOptions()));
  file->insertSeparator();
  file->insertItem ("&Exit", this, SLOT (slotQuit()), kkeys->quit());
  netmenu = new QPopupMenu ();
  CHECK_PTR(netmenu);
  netmenu->insertItem ("&General Interface Stats", this, SLOT (slotGeneral()));
  netmenu->insertItem ("&Detailed Interface Stats", this, SLOT (slotDetailed()));
  netmenu->insertItem ("&Port Statistics", this, SLOT (slotPort()));

  filtermenu = new QPopupMenu ();
  filtermenu->insertItem ("&Port filter add/list", this, SLOT (slotPortFilter()));

  help=kapp->getHelpMenu(TRUE, VERSIONSTR);
  help->setAccel(0,0);

  /**
    Set up the menubar.
    */
  menubar = new KMenuBar (this);
  menubar->insertItem ("&File",file);
  menubar->insertItem ("&Network",netmenu);
  menubar->insertItem ("&Filter",filtermenu);
  menubar->insertSeparator ();        //This pushes the Help menu to
                                      //the far right when KDE is in
                                      //Motif widget mode
  menubar->insertItem ("&Help",help);

  /**
    Set up the toolbar.
    */
  toolbar = new KToolBar(this);
  QString optpict, genpict, detpict, prtpict;

  /**
    The method for accessing the toolbar directory has changed
     since the writing of the article.
    The original line was
       buttonpicture = kapp->kdedir()+"/share/toolbar/exclamation.xpm";
    The new line is below.
  **/
  optpict =kapp->kde_datadir()+"/ksniffer/toolbar/opt.xpm";
  toolbar->insertButton (QPixmap (optpict.data()),0,
			 SIGNAL (released()),
			 this, SLOT (slotOptions()),TRUE,
			 "Set KSniffer Options/Prefs");
  genpict =kapp->kde_datadir()+"/ksniffer/toolbar/gen.xpm";
  toolbar->insertButton (QPixmap (genpict.data()),0,
			 SIGNAL (released()),
			 this, SLOT (slotGeneral()),TRUE,
			 "View All Interfaces General Stats");
  detpict =kapp->kde_datadir()+"/ksniffer/toolbar/det.xpm";
  toolbar->insertButton (QPixmap (detpict.data()),0,
			 SIGNAL (released()),
			 this, SLOT (slotDetailed()),TRUE,
			 "View A Specific Interface's Detailed Stats");
  prtpict =kapp->kde_datadir()+"/ksniffer/toolbar/prt.xpm";
  toolbar->insertButton (QPixmap (prtpict.data()),0,
			 SIGNAL (released()),
			 this, SLOT (slotPort()),TRUE,
			 "View Port Specific Traffic");



  /**
    Tell KTopWidget about our menubar, toolbar, and 
    label.
    */

  setMenu (menubar);
  addToolBar (toolbar);

//  myEdit = new QMultiLineEdit(this,"My Debug dump");
//  myEdit->setGeometry(0,58,348,240);
//  setView(myEdit,TRUE);

  //Setup the StatusBar at the bottom of the window
  statusbar = new KStatusBar(this, "Status Bar");
  setStatusBar(statusbar);
  statusbar->message("Initialized");

  //Options area here
  config->setGroup("Global");
  options.promisc = config->readNumEntry("promisc", 0);
  options.actmode = config->readNumEntry("actmode",1);

  config->setGroup("General");
  options.genopts.total = config->readNumEntry("total", 1);
  options.genopts.total_ip = config->readNumEntry("total_ip", 1);
  options.genopts.non_ip = config->readNumEntry("non_ip", 1);
  options.genopts.bad_ip = config->readNumEntry("bad_ip", 1);
  options.genopts.activity = config->readNumEntry("activity", 1);

  config->setGroup("Detailed");
  options.detopts.pkts = config->readNumEntry("pkts", 1);
  options.detopts.bytes = config->readNumEntry("bytes", 1);
  options.detopts.activity = config->readNumEntry("activity", 1);

  config->setGroup("Port");
  options.servnames = config->readNumEntry("servnames",1);
  options.portopts.pkts = config->readNumEntry("pkts", 1);
  options.portopts.bytes = config->readNumEntry("bytes", 1);
  options.portopts.pkts_to = config->readNumEntry("pkts_to", 0);
  options.portopts.bytes_to = config->readNumEntry("bytes_to", 0);
  options.portopts.pkts_from = config->readNumEntry("pkts_from", 0);
  options.portopts.bytes_from = config->readNumEntry("bytes_from", 0);
  options.portopts.activity = config->readNumEntry("activity", 1);

  generalrunning=0;  //So if the user selects options before stats are run
  detailedrunning=0;  //So if the user selects options before stats are run
  portrunning=0;  //So if the user selects options before stats are run

  qstrcpy((char *)&iface, "none");

  adjustSize();
  show();
}

/****************************************************
 KSniffer::~KSniffer ()
   This gets called when the user has selected quit
   and QT wants to clean up our app.
*****************************************************/
KSniffer::~KSniffer()
{
}


/* slotQuit():
   This gets called when the user has selected quit
*/
void KSniffer::slotQuit()
{
  close();
}

/****************************************************
 closeEvent():
   This gets called when the user has selected quit
*****************************************************/
void KSniffer::closeEvent (QCloseEvent *)
{
  //Ok save settings

  config->setGroup("Global");
  config->writeEntry("promisc", options.promisc);
  config->writeEntry("actmode", options.actmode);

  config->setGroup("General");
  config->writeEntry("total", options.genopts.total);
  config->writeEntry("total_ip", options.genopts.total_ip);
  config->writeEntry("non_ip", options.genopts.non_ip);
  config->writeEntry("bad_ip", options.genopts.bad_ip);
  config->writeEntry("activity", options.genopts.activity);

  config->setGroup("Detailed");
  config->writeEntry("pkts", options.detopts.pkts);
  config->writeEntry("bytes", options.detopts.bytes);
  config->writeEntry("activity", options.detopts.activity);

  config->setGroup("Port");
  config->writeEntry("servnames", options.servnames);
  config->writeEntry("pkts", options.portopts.pkts);
  config->writeEntry("bytes", options.portopts.bytes);
  config->writeEntry("pkts_to", options.portopts.pkts_to);
  config->writeEntry("bytes_to", options.portopts.bytes_to);
  config->writeEntry("pkts_from", options.portopts.pkts_from);
  config->writeEntry("bytes_from", options.portopts.bytes_from);
  config->writeEntry("activity", options.portopts.activity);

  config->sync();

  srpromisc(0);
  kapp->quit();
}

/****************************************************
 slotGeneral():
   This gets called when the user selects 
   General Interface Stats.  It shows only the basic
   network stats for each interface.
*****************************************************/
void KSniffer::slotGeneral()
{
  //Clean up the general stats if its running
  if (detailedrunning)
    {
     delete(ifstatsdetailed);
     detailedrunning=0;
    }
  else if (portrunning)
    {
     delete(ifportstats);
     portrunning=0;
    }
  else if (generalrunning)
     delete(ifstatsgeneral);

  generalrunning=1;

  ifstatsgeneral = new IfStatsGeneral(this, &options);
  setView(ifstatsgeneral->mylistview, TRUE);
//  setView(ifstatsgeneral);
  {
    QRect win = this->geometry();
    this->resize(win.width(), win.height()+1);
    this->resize(win.width(), win.height()-1);
  }
  statusbar->message("General Interface Stats");
}

/****************************************************
 slotDetailed():
   This gets called when the user selects 
   General Interface Stats
*****************************************************/
void KSniffer::slotDetailed()
{
  selectIfaceModal *myiface;
  char iface[8];

  myiface = new selectIfaceModal(this, "SelectIFace");
  myiface->show();
  qstrcpy((char *)&iface, myiface->iface);
  delete (myiface);

  //Clean up the general stats if its running
  if (generalrunning)
    {
     delete(ifstatsgeneral);
     generalrunning=0;
    }
  else if (portrunning)
    {
     delete(ifportstats);
     portrunning=0;
    }
  else if (detailedrunning)
     delete(ifstatsdetailed);

  detailedrunning=1;


  ifstatsdetailed = new IfStatsDetailed(this, (char *)&iface, &options);
  setView(ifstatsdetailed->mylistview, TRUE);
  {
    QRect win = this->geometry();
    this->resize(win.width(), win.height()+1);
    this->resize(win.width(), win.height()-1);
  }
  statusbar->message("Detailed Interface Stats");

}

/****************************************************
 slotPort():
   This gets called when the user selects 
   Port Stats
*****************************************************/
void KSniffer::slotPort()
{
  selectIfaceModal *myiface;

  KMsgBox *mybox;
  mybox = new KMsgBox(this, "Notice", "The default is to only monitor ports < 1024\n\nAdd new ports in the Filter Menu", 2,"ok",0,0,0);
  mybox->show();

  myiface = new selectIfaceModal(this, "SelectIFace");
  myiface->show();
  qstrcpy((char *)&iface, myiface->iface);
  delete (myiface);

  //Clean up the general stats if its running
  if (generalrunning)
    {
     delete(ifstatsgeneral);
     generalrunning=0;
    }
  else if (detailedrunning)
    {
     delete(ifstatsdetailed);
     detailedrunning=0;
    }
  else if (portrunning)
     delete(ifportstats);

  portrunning=1;

  ifportstats = new IpPortStats(this, (char *)&iface, &options);
  setView(ifportstats->mylistview, TRUE);
  {
    QRect win = this->geometry();
    this->resize(win.width(), win.height()+1);
    this->resize(win.width(), win.height()-1);
  }
  statusbar->message("Port Statistics");
}

/****************************************************
 slotOptions():
   This gets called when the user selects 
   General Interface Stats
*****************************************************/
void KSniffer::slotOptions()
{
  OptionsModal *myoptions;

  myoptions = new OptionsModal(this, "Options", &options);
  myoptions->show();
/*
  myoptions->promisc->setChecked(options.promisc);

  myoptions->show();
  options.promisc = myoptions->promisc->isChecked();
  options.actmode = !myoptions->ratebits->isChecked();
  options.servnames = myoptions->servnames->isChecked();
 
  if (generalrunning)
    ifstatsgeneral->updateOptions(&options);
  else if (detailedrunning)
    ifstatsdetailed->updateOptions(&options);
  else if (portrunning)
    ifportstats->updateOptions(&options);

*/
}

/****************************************************
 slotPortFilter():
   This gets called when the user selects 
   Port Filter.  They want to see the list of 
   additional ports above 1024 to be filtered in the
   port stats.
*****************************************************/
void KSniffer::slotPortFilter()
{
  PortFilterModal *myportfilter;

  myportfilter = new PortFilterModal(this, "SelectIFace");
  myportfilter->show();
  //  delete(myportfilter);

  if (!myportfilter->hitcancel)
  if (portrunning)
    {
      delete(ifportstats);
      ifportstats = new IpPortStats(this, (char *)&iface, &options);
      setView(ifportstats->mylistview, TRUE);
      statusbar->message("Port Statistics");
    }
  
}


int main (int argc, char *argv[])
{
  KApplication app (argc, argv, "ksniffer");
  KSniffer *sniffer;

  config = new KSimpleConfig(CONFIG_FILE);

  sniffer = new KSniffer();
  app.setMainWidget(sniffer);
  app.setTopWidget(sniffer);

  return app.exec();
}
