#ifndef _KSNIFFER_H
#define _KSNIFFER_H

#include <kapp.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kslider.h>
#include <qmultilinedit.h>
#include <drag.h>
#include <qdialog.h>
#include <qtabdialog.h>
#include <qframe.h>
#include <qimage.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include "kifstats.h"
#include "kportstats.h"
#include "options.h"

class KSniffer : public KTopLevelWidget
{
  Q_OBJECT;

public:
  KStatusBar *statusbar;
  QMultiLineEdit *myEdit;
  QString *tempstr1, *tempstr2;
  QGridLayout *mainlayout;
  IfStatsGeneral *ifstatsgeneral;
  IfStatsDetailed *ifstatsdetailed;
  IpPortStats *ifportstats;
  int fd,c;
  struct OPTIONS options;
  char iface[8]; //interface name

  //The app object
  KSniffer (void); 		
  ~KSniffer(void);
  void closeEvent (QCloseEvent *);      

private:
  QPopupMenu *file, *netmenu, *filtermenu, *help;
  KToolBar *toolbar;
  KMenuBar *menubar;
  QLabel *label;
  KDNDDropZone *dropzone;
  QListView *mylistview;
  int generalrunning;    //Lets the options know we are running 
  int detailedrunning;   //Lets the options know we are running 
  int portrunning;       //Lets the options know we are running 

public  slots:
  void slotQuit();
  void slotGeneral();
  void slotDetailed();
  void slotPort();
  void slotPortFilter();
  void slotOptions();
};
#endif
