#ifndef _KOPTIONS_H
#define _KOPTIONS_H

struct gen_opts {
	unsigned int total;
	unsigned int total_ip;
	unsigned int non_ip;
	unsigned int bad_ip;
	unsigned int activity;
};

struct det_opts {
	unsigned int pkts;
	unsigned int bytes;
	unsigned int activity;
};

struct port_opts {
	unsigned int pkts;
	unsigned int bytes;
	unsigned int pkts_to;
	unsigned int bytes_to;
	unsigned int pkts_from;
	unsigned int bytes_from;
	unsigned int activity;
};


struct OPTIONS {
    unsigned int logging:1, 
                 revlook:1, 
                 servnames: 1, 
                 promisc:1,
                 actmode:1,
                 dummy:9;
    unsigned int timeout;
    unsigned int logspan;
    unsigned int updrate;
    struct gen_opts genopts;
    struct det_opts detopts;
    struct port_opts portopts;
};

#define KBITS 0
#define KBYTES 1
#define DEFAULT_UPDATE_DELAY 50000     /* usec screen delay if update rate 0 */
#define HOSTMON_UPDATE_DELAY 100000

#endif
