/***************************************************************************
                          knd_load.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef 	KSNUFFLELOAD_H 
#define 	KSNUFFLELOAD_H 

#ifdef 		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<qframe.h>
#include	<qtooltip.h>

#include 	"ksnuffle.h"
#include	"knd_multi.h"
#include	"knd_pcap.h"
#include	"knd_pkt.h"

/*  MINLOAD specifies the minimum scale for the load display, in bytes	*/
/*  Note that it _must_ be a power of 10 for the scale adjustment code	*/
/*  to work!								*/
#define		MINLOAD	100

/*  MINPCNT similarly specifies the minimum scale for the packet count	*/
/*  display. Again, it _must_ be a power of 10.				*/
#define		MINPCNT	10


typedef	struct
{	int	pktlen	;
	int	datlen	;
}	LoadPair ;

/*  KNDLoadHist								*/
/*  -----------								*/

/*  This class is responsible for displaying a sliding histogram which	*/
/*  shows the traffic load, marking actual data and actual network	*/
/*  traffic. Note that the parent object is responsible for displaying	*/
/*  any labels around it.						*/

class	KNDLoadHist : public QFrame
{
	Q_OBJECT

	LoadPair	*pktcnt	;	/* Packet data counts		*/
	LoadPair	*dispval;	/* Display values		*/
	int		x	;
	int		y	;
	int		w	;	
	int		h	;

	int		offsetp	;
	int		offsetd	;

	int		nsecs	;	/* Shift interval in seconds	*/
	int		tickno	;	/* Tick number for shifting	*/
	bool		frozen	;	/* Display is frozen		*/
	long		second	;	/* Current time in seconds	*/
	int		insert	;	/* Insertion offset		*/

	bool		adjust	;	/* Automatic scale adjustment	*/
	int		scpref	;	/* Current preferred scale	*/
	int		sccurr	;	/* Scale currently being used	*/
	int		scdown	;	/* Scale reduction point	*/
	int		maxval	;

	inline	int	boundary
		(	int	v
		)
	{
		return	h - (v * h) / sccurr ;
	}

	void	reScale	()	;

public	:
	KNDLoadHist	  (QWidget *, int, int, int, int, int, bool = true) ;
       ~KNDLoadHist	  () ;

	void	addPacket (PktInfo *) ;
	int	timerTick (long) ;
	void	freeze	  (bool) ;
	void	setScale  (int)	 ;

protected :

	virtual	void	drawContents		(QPainter    *) ;
	virtual	void	mouseDoubleClickEvent	(QMouseEvent *) ;

signals :

	void	doubleClick () ;
}	;


/*  KNDLoadBar								*/
/*  ----------								*/

/*  This class draws a load bar showing network traffic over the	*/
/*  previous N seconds, where N is configurable.			*/

class	KNDLoadBar : public QFrame
{
	Q_OBJECT

	LoadPair	*pktcnt	;	/* Packet data counts		*/
	LoadPair	dispval	;	/* Display values		*/
	int		nsecs	;
	
	int		x	;
	int		y	;
	int		w	;
	int		h	;
	int		offset	;
	int		scale	;
	bool		frozen	;	/* Display is frozen		*/
	long		second	;	/* Current time in seconds	*/
	int		insert	;	/* Insertion offset		*/

	inline	int	boundary
		(	int	v
		)
	{
		return	h - (v * h) / scale ;
	}

	void	reScale	()	;

public	:
	KNDLoadBar	  (QWidget *, int, int, int, int, int) ;
       ~KNDLoadBar	  () ;

	void	addPacket (PktInfo *) ;
	void	timerTick (long) ;
	void	freeze	  (bool) ;

	inline	void	setScale
		(	int	s
		)
	{
		scale	= s ;
	}

protected :

	virtual	void	drawContents		(QPainter    *) ;
	virtual	void	mouseDoubleClickEvent	(QMouseEvent *) ;

signals:

	void	doubleClick () ;
}	;

/*  KNDPktHist								*/
/*  ----------								*/

/*  This class is responsible for displaying a sliding histogram which	*/
/*  shows the packet count. Note that the parent object is responsible	*/
/*  for displaying any labels around it.				*/

class	KNDPktHist : public QFrame
{
	Q_OBJECT

	int		*pktcnt	;	/* Packet data counts		*/
	int		*dispval;	/* Display values		*/
	int		x	;
	int		y	;
	int		w	;	
	int		h	;

	int		offsetp	;
	int		offsetd	;

	int		nsecs	;	/* Shift interval in seconds	*/
	int		tickno	;	/* Tick number of shifting	*/
	bool		frozen	;	/* Display is frozen		*/
	long		second	;	/* Current time in seconds	*/
	int		insert	;	/* Insertion offset		*/

	bool		adjust	;	/* Automatic scale adjustment	*/
	int		scpref	;	/* Current preferred scale	*/
	int		sccurr	;	/* Scale currently being used	*/
	int		scdown	;	/* Scale reduction point	*/
	int		maxval	;

	inline	int	boundary
		(	int	v
		)
	{
		return	h - (v * h) / sccurr ;
	}

	void	reScale	()	;

public	:
	KNDPktHist	  (QWidget *, int, int, int, int, int, bool = true) ;
       ~KNDPktHist	  () ;

	void	addPacket (PktInfo *) ;
	int	timerTick (long) ;
	void	freeze	  (bool) ;
	void	setScale  (int)	 ;

protected :

	virtual	void	drawContents		(QPainter    *) ;
	virtual	void	mouseDoubleClickEvent	(QMouseEvent *) ;

signals :

	void	doubleClick () ;
}	;

#endif // KSNUFFLELOAD_H 
