/***************************************************************************
                          knd_pcap.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef		KNDMON_H 
#define		KNDMON_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<unistd.h>
#include	<signal.h>
#include	<pthread.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<errno.h>

#include	<qmessagebox.h>

#include	<kapp.h>
#include	<ktabctl.h>
#include	<kcombo.h>
#include	<ksock.h>

extern	"C"
{
#include	<pcap-int.h>
#include	<pcap.h>
}	;

#include	"ksnuffle.h"
#include	"knd_multi.h"
#include	"knd_pkt.h"
#include	"knd_gra.h"

typedef	struct	bpf_program	BPFPROG	;
typedef		bpf_u_int32	BFPI32	;

/*  KNDPCap	: Ksnuffle packet capture				*/
/*  Instance of this class handle a particular capture configuration.	*/
/*  There is one instance for each monitor created by the user.		*/

class	KNDPCap : public QObject
{
	Q_OBJECT

	bool	  	execing	;	/* Monitor is executing		*/

	pcap_t	  	*pd	;	/* Monitor connection		*/
	BPFPROG	  	program	;	/* Monitor program		*/
	int	  	snaplen	;	/* Packet snap length		*/
	int	  	sockp[2];	/* Socket to monitor thread	*/
	KSocket	  	*ksock	;	/* Socket at KNDPCap end	*/
#ifdef	_PTHREAD
	pthread_t 	thread	;	/* Monitor thread		*/
#else	/* _PTHREAD */
	pid_t		pid	;	/* Monitor process		*/
#endif	/* _PTHREAD */
	QString		logfile	;	/* Log file name		*/
	FILE		*logfd	;	/* Log file or NULL		*/
	bool		binary	;	/* Log binary			*/
	int		options	;	/* Monitor options		*/

	KNDGraphic	*graphic;
	KNDPacket	*packets;
	KNDMulti	*multi	;
	int		slot	;

	void	clear	()	;
	void	error	(char *, char *, QMessageBox::Icon) ;

public	:
	KNDPCap 	(KNDGraphic *, KNDPacket *, KNDMulti *, int) ;
       ~KNDPCap		() ;

	bool	execute	   (bool, FILE * = NULL, bool = false) ;
	bool	setProg	   (const char *, const char *) ;
	void	setOptions (int)  ;

	inline	int	wrSock	() { return sockp[0]	; }
	inline	pcap_t *getPcap	() { return pd		; }

private	slots :

	void	sockRead (KSocket *) ;
	
}	;

#endif	// KNDMON_H 
