#ifndef INCLUDE_KSOA_H
#define INCLUDE_KSOA_H

#include <ktopwidget.h>
#include <klined.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbt.h>
#include <qmsgbox.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <string.h>
#include <iostream.h>

extern int h_errno;
extern int errno;

#define NSLIMIT 20

class klist : public QListBox
{
	Q_OBJECT
public:
	klist(QWidget *parent=0, const char *name=0, WFlags f=0 )
	: QListBox(parent,name,f) {};
	int current_line;
public slots:
	void mousePressEvent(QMouseEvent *);
signals:
	void popup(int,int,int);
};

class ksoa : public KTopLevelWidget
{
	Q_OBJECT
public:
	ksoa(QWidget *parent=0, const char *name=0);
	~ksoa();
	QLabel *label;
	KLined *line;
	KStatusBar *statusbar;
	klist *box;
	QPushButton *helpb, *quitb;
	QPopupMenu *helpMenu;
	void resizeEvent(QResizeEvent *);
public slots:
	void doit();
	void showhelp();
	void showpopup(int,int,int);
	void popcallback(int);
	void nsError(int, char *);
	void findNameServers(char *, char **, int *);
	void queryNameServers(char *, char **, int);
	void returnCodeError(int, char *);
	int skipToData(unsigned char *, unsigned char *, unsigned short *, unsigned short *, unsigned int *, unsigned short *, unsigned char *);
	int skipName(unsigned char *, unsigned char *, unsigned char *);
};

#endif
