#include <iostream.h>

#include "cassette.h"
#include "movies.h"
#include "bstar.h"
#include "options.h"

extern BStarTree *anchor;
extern Config config;

Cassette::Cassette()
{
  lenTot=0;
  for(int i=1;i<13;i++){
    start[i]=0;
    length[i]=0;
    factor[i]=0.0;
    title[i]="";
    speed[i]="";
  }
}

int sFreeSpace(Cassette *cass)
{
  int result=60000;
  
  for (int i=1; i<13; i++){
    if (cass->title[i] != ""){
      if (cass->start[i] < result)
	result=cass->start[i];
    }
  }
  return result;
}
    
int bFreeSpace(Cassette *cass)
{
  int starts[13];
  int ends[13];
  int result=0;
  for (int i=1; i<13; i++){
    starts[i] = cass->start[i];
    ends[i] = cass->start[i]+cass->length[i];
  }
  
  // sort all start values
  for (int i=1; i < 13; i++)
    for (int j=1; j < (13-i); j++)
      if (starts[j] >= starts[j+1])
	if ((starts[j]==starts[j+1]) && (ends[j] > ends[j+1])){
	  int help;
	  help = starts[j];
	  starts[j] = starts[j+1];
	  starts[j+1] = help;
	  help = ends[j];
	  ends[j] = ends[j+1];
	  ends[j+1] = help;
	}
  
  // determine biggest space between two movies
  for (int i=1; i < 12; i++){
    if (starts[i+1]-ends[i] > result)
      result = starts[i+1]-ends[i];
  }
  
  return result;
}

int eFreeSpace(Cassette *cass)
{
  int starts[13];
  int ends[13];
  int result=0;
  for (int i=1; i<13; i++){
    starts[i] = cass->start[i];
    ends[i] = cass->start[i]+cass->length[i];
  }
  
  result = ends[1];
  // determine latest end-value
  for (int i=1; i < 13; i++){
    if (ends[i] > result)
      result = ends[i];
  }
  
  return cass->lenTot-result;
}

int Cassette::maxSpace()
{
  int starting;
  int between;
  int ending;

  starting = sFreeSpace(this);
  between = bFreeSpace(this);
  ending = eFreeSpace(this);
  
  if ((starting >= between) && (starting >= ending))
    return starting;
  else if ((between >= starting) && (between >= ending))
    return between;
  else
    return ending;
}
