/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
                                       
#include <stdio.h>
#include <qfiledlg.h>

#include <kfiledialog.h>
#include "dbconfig.moc"



Configure::Configure(QWidget *parent, const char *name):QTabDialog( parent, name,true) {
	this->setCaption(klocale->translate("Database configuration"));
	this->resize(580,300);
	


	this->setCancelButton();
	

	QWidget *Eins = new QWidget(this,"page one");
	this->addTab(Eins,klocale->translate("General options"));
	QWidget *Fonts = new QWidget(this,"Fonts");
	this->addTab(Fonts,klocale->translate("Fonts"));

	QWidget *Eingabe = new QWidget(this,"input");
	this->addTab(Eingabe,klocale->translate("Editing"));
     Recorder = new QComboBox(FALSE,Eins,"recorder");  

QToolTip::add(Recorder,klocale->translate("Choose what type of Recorder You have."));

	QWidget *IMDB = new QWidget(this,"IMDb");
	this->addTab(IMDB,klocale->translate("IMDb"));

	QWidget *SUBCLASS = new QWidget(this,"SubClasses");
	this->addTab(SUBCLASS,klocale->translate("Subclasses"));
	QWidget *CSFIMPORT = new QWidget(this,"CSF Import");
	this->addTab(CSFIMPORT,klocale->translate("ASCII Import"));



QLabel *CSFDescripe = new QLabel(CSFIMPORT,klocale->translate("Define a rule for ASCII import.\nPlease read the online help for more details."),CSFIMPORT);
CSFDescripe->adjustSize();
CSFDescripe->move(10,10);
CSFField = new QLineEdit(CSFIMPORT,"test");
CSFField->move(10,110);
CSFField->resize(150,20);
QLabel *CSFDescribe2 = new QLabel(CSFIMPORT,klocale->translate("Rule:"),CSFIMPORT);
CSFDescribe2->move(10,80);
QLabel *CSFDescribe3 = new QLabel(CSFIMPORT,klocale->translate("Field Separator:"),CSFIMPORT);
CSFDescribe3->move(200,80);CSFDescribe3->adjustSize();
CSFSeparator = new QComboBox(TRUE,CSFIMPORT,"test");
CSFSeparator->move(200,110);
CSFSeparator->insertItem(",",0);
CSFSeparator->insertItem(":",1);
CSFSeparator->insertItem(";",2);
CSFSeparator->insertItem("-",3);




		
QLabel *SubDescribe = new QLabel(SUBCLASS,klocale->translate("Enter the text for the subclasses."),SUBCLASS);
SubDescribe->adjustSize();
SubDescribe->move(10,10);
SubClass1 = new QLineEdit(SUBCLASS,"1");
SubClass2 = new QLineEdit(SUBCLASS,"2");
SubClass3 = new QLineEdit(SUBCLASS,"3");
SubClass4 = new QLineEdit(SUBCLASS,"4");
SubClass5 = new QLineEdit(SUBCLASS,"5");
SubClass1->move(30,40);
SubClass2->move(30,70);
SubClass3->move(30,100);
SubClass4->move(30,130);
SubClass5->move(30,160);
SubClass1->resize(300,20);
SubClass2->resize(300,20);
SubClass3->resize(300,20);
SubClass4->resize(300,20);
SubClass5->resize(300,20);



	QPixmap Hintergrund;
	char Filename[90];
	   strcpy(Filename,kapp->kde_htmldir());
        strcat(Filename,"/en/kvideolist/imdb.xpm");
        Hintergrund.load(Filename);             
QLabel *Hintergrund1= new QLabel(IMDB," ");
        Hintergrund1->setPixmap(Hintergrund);

        Hintergrund1->resize(198,82);
        Hintergrund1->move(350,10);            
	
	  AskOnline= new QCheckBox(klocale->translate("Ask before going online"),IMDB);   
	AskOnline->adjustSize();AskOnline->move(10,10);
QToolTip::add(AskOnline,klocale->translate("Wether KVideolist should ask for an \n active Internet connection or not."));
AutoFillRule= new QComboBox(FALSE,IMDB,"hmm");
AutoFillRule->insertItem(klocale->translate("Title first, then original name"),0);
AutoFillRule->insertItem(klocale->translate("Original name first, then title"),1);

QLabel *AutoFillRuleL = new QLabel(IMDB,klocale->translate("Autofill rule:"),IMDB);
AutoFillRuleL->move(10,30);
AutoFillRule->move(120,35);
AutoFillRule->resize(235,20);


FetchProducer=new QCheckBox(klocale->translate("Producer"),IMDB);
FetchProducer->adjustSize();FetchProducer->move(10,200-150+20);

QToolTip::add(FetchProducer,klocale->translate("Should the Producer entry be taken from IMDB?"));


FetchGenres= new QCheckBox(klocale->translate("Genres"),IMDB);
FetchGenres->adjustSize();FetchGenres->move(150,200-150+20);
QToolTip::add(FetchGenres,klocale->translate("Should the Genre entries copied from IMDB?"));


FetchDirector=new QCheckBox(klocale->translate("Director"),IMDB);
FetchDirector->adjustSize();FetchDirector->move(10,240-150+20);

QToolTip::add(FetchDirector,klocale->translate("Should the Director-entry copied from IMDB?"));


FetchCast= new QCheckBox(klocale->translate("the Cast"),IMDB);
FetchCast->adjustSize();FetchCast->move(150,240-150+20);
QToolTip::add(FetchCast,klocale->translate("Should the cast copied from IMDB?"));


FetchCountry= new QCheckBox(klocale->translate("Country/State"),IMDB);
FetchCountry->adjustSize();FetchCountry->move(10,280-150+20);
QToolTip::add(FetchCountry,klocale->translate("Should the country where the movie was made\n taken from IMDB?"));


FetchYear= new QCheckBox(klocale->translate("year of release"),IMDB);
FetchYear->adjustSize();FetchYear->move(150,280-150+20);
QToolTip::add(FetchYear,klocale->translate("Should the release year \n taken from IMDB?"));
AutoFetchGenres= new QCheckBox(klocale->translate("try to fetch genres automatically"),IMDB);
AutoFetchGenres->move(10,320-150+20);AutoFetchGenres->adjustSize();
QToolTip::add(AutoFetchGenres,klocale->translate("Enable this if KVideolist should try to fill out the Genres \nautomatically. If disabled, KVideolist lets You choose."));


QLabel *Which = new QLabel(IMDB);
Which->setText(klocale->translate("Select the data You want to retrieve:"));
Which->adjustSize();Which->move(10,55);





	QLabel *RecorderL1 = new QLabel(Eins);
	RecorderL1->setText(klocale->translate("Indexing Method:"));
	RecorderL1->move(10,26);	
	RecorderL1->adjustSize();
    SortMode= new QComboBox(FALSE,Eins,"sortmode");  
	QLabel *SortModeL= new QLabel(Eins);
SortModeL->setText(klocale->translate("Default Sortmode:"));
	SortModeL->resize(160,25);SortModeL->move(10,0);

QToolTip::add(SortMode,klocale->translate("Select the sortmode on startup."));


	SortMode->insertItem(klocale->translate("by Name"),0);
	SortMode->insertItem(klocale->translate("by release-year"),1);
	SortMode->insertItem(klocale->translate("by tape-number"),2);
	SortMode->insertItem(klocale->translate("by rating"),3);
	SortMode->insertItem(klocale->translate("by playtime"),4);
	SortMode->resize(228,20);SortMode->move(177,0);
	Recorder->insertItem(klocale->translate("VISS (VHS Index Search System)."),0);
	Recorder->insertItem(klocale->translate("time-counter."),1);
	Recorder->insertItem(klocale->translate("VISS and time-counter."),2);
	Recorder->resize(228,20);Recorder->move(177,26);

QLabel *Adding = new QLabel(Eingabe);
Adding->setText(klocale->translate("Default settings on Movie->Add:"));
Adding->adjustSize();
Adding->move(10,50);

	DefStereo= new QCheckBox(klocale->translate("Stereo"),Eingabe);
	DefStereo->resize(66,24); DefStereo->move(267,50);
	DefSurround = new QCheckBox(klocale->translate("Surround"),Eingabe);

	DefSurround->resize(116,22); DefSurround->move(347,51);
	DefLongPlay = new QCheckBox(klocale->translate("LongPlay"),Eingabe);
	DefLongPlay->resize(100,21);DefLongPlay->move(478,51);
        DefColor= new QCheckBox(klocale->translate("Color"),Eingabe);
	DefColor->resize(67,23);DefColor->move(267,69);

	DefMovieText= new QCheckBox(klocale->translate("MovieText"),Eingabe);
	DefMovieText->resize(100,24);DefMovieText->move(347,68);
	DefAutoShow = new QCheckBox(klocale->translate("Automatically open linked URL"),Eingabe);

	DefAutoShow->resize(309,22);DefAutoShow->move(267,86);
 	QLabel *GeneralL = new QLabel(this,klocale->translate("General default settings:"),this);
	GeneralL->resize(150,20);GeneralL->move(23,108);
	GeneralL->hide();

	AutoLoad= new QCheckBox(klocale->translate("Load last used database on startup"),Eins);
	AutoLoad->adjustSize();
	AutoLoad->move(23,70);
ChangeTitleFont= new QPushButton(klocale->translate("Change title font"),Fonts);
ChangeOriginalTitleFont= new QPushButton(klocale->translate("Change original-title font"),Fonts);
ChangeLabelFont = new QPushButton(klocale->translate("Change label font"),Fonts);
ChangeOtherFont = new QPushButton(klocale->translate("Change font for Director, Producer and Cast"),Fonts);
ChangeTitleFont->adjustSize();
ChangeOriginalTitleFont->adjustSize();
ChangeLabelFont->adjustSize();
ChangeOtherFont->adjustSize();
ChangeTitleFont->move(10,10);
ChangeOriginalTitleFont->move(10,50);
ChangeLabelFont->move(10,100);
ChangeOtherFont->move(10,150);
connect(ChangeTitleFont,SIGNAL(clicked()),SLOT(slotChangeTitleFont()));
connect(ChangeOriginalTitleFont,SIGNAL(clicked()),SLOT(slotChangeOriginalTitleFont()));
connect(ChangeLabelFont,SIGNAL(clicked()),SLOT(slotChangeLabelFont()));
connect(ChangeOtherFont,SIGNAL(clicked()),SLOT(slotChangeOtherFont()));
	
	QPushButton *BackgroundChange = new QPushButton(klocale->translate("Change background image..."),Eins);
	BackgroundChange->resize(216,16);BackgroundChange->move(31,135);
	BackgroundLine = new QLineEdit(Eins,"bg");
	BackgroundLine->resize(214,21);BackgroundLine->move(31,154);
	BackgroundDisable= new QCheckBox(klocale->translate("no background image"),Eins);
	BackgroundDisable->resize(151,20);BackgroundDisable->move(31,175);
	Resort= new QCheckBox(klocale->translate("Automatic Re-Sort"),Eingabe);
	Resort->move(268,132);Resort->resize(280,24);
	AutoIndexing = new QCheckBox(klocale->translate("use automatic indexing"),Eingabe);
	AutoIndexing->move(268,154);AutoIndexing->resize(300,17);
	TapeView= new QCheckBox(klocale->translate("Tape view"),Eins);
	TapeView->move(268,176);TapeView->resize(300,17);

	QPushButton *OK = new QPushButton(klocale->translate("Save"),this);
	OK->move(20,255);
	OK->hide();

	QPushButton *CANCEL = new QPushButton(klocale->translate("Cancel"),this);
	CANCEL->move(300,255);
	CANCEL->hide();
//	connect(OK,SIGNAL(clicked()),SLOT(slotOKPressed()) );
	connect(this,SIGNAL(applyButtonPressed()),SLOT(slotOKPressed()));
	
//      connect(CANCEL,SIGNAL(clicked()),SLOT(slotCANCELPressed()) );
	connect(this,SIGNAL(cancelButtonPressed()),SLOT(slotCANCELPressed()));

	connect(BackgroundChange,SIGNAL(clicked()),SLOT(slotSelect()) );

	
};

void Configure::slotOKPressed() {
	
	accept(); 
};

void Configure::slotChangeTitleFont() {
	KFontDialog *Selection= new KFontDialog(this,"selection");
	Selection->getFont(TitleFont);
	ChangeTitleFont->setFont(TitleFont);
	ChangeTitleFont->adjustSize();
	};

void Configure::slotChangeOriginalTitleFont() {
	      KFontDialog *Selection= new KFontDialog(this,"selection");
        Selection->getFont(OriginalTitleFont);
	ChangeOriginalTitleFont->setFont(OriginalTitleFont);
	ChangeOriginalTitleFont->adjustSize();
        };
   
void Configure::slotChangeLabelFont() {
		KFontDialog *Selection= new KFontDialog(this,"selection");
	Selection->getFont(LabelFont);
	ChangeLabelFont->setFont(LabelFont);
	ChangeLabelFont->adjustSize();
	};
void Configure::slotChangeOtherFont() {
		KFontDialog *Selection=new KFontDialog(this,"selection");
	Selection->getFont(OtherFont);
	ChangeOtherFont->setFont(OtherFont);
	ChangeOtherFont->adjustSize();

	};


void Configure::slotCANCELPressed() {
	reject();
};

void Configure::slotSelect() {
	QString s=QFileDialog::getOpenFileName(0,"*.xpm",this);
	BackgroundLine->setText(s);

};
		
