/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
                                       
#include <stdio.h>
#include <qfiledlg.h>
#include "mlist.h"
#include "importer.moc"
#include <kfiledialog.h>


Importer::Importer(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
	this->setCaption(klocale->translate("Import"));
	this->resize(580,300);

	QLabel *From = new QLabel(this,klocale->translate("Select format:"),this);
	From->resize(160,30);
	From->move(20,10);
	Version=new QComboBox(FALSE,this,"version");
	Version->insertItem(klocale->translate("ASCII Files"),0);
	Version->insertItem(klocale->translate("DB2 - StarOffice, dBase"),1);

	Version->adjustSize();
	Version->move(183,20);
	
	QPushButton *Filechange = new QPushButton(klocale->translate("Filename..."),this);
	Filechange->resize(214,20);Filechange->move(31,135);
	Filename = new QLineEdit(this,"filename");
	Filename->resize(214,25);Filename->move(31,154);
	QLabel *TargetL = new QLabel(this,klocale->translate("Target filename..."),this);
	TargetL->resize(214,20);
	TargetL->move(260,135);
	TargetL->show();
	QLabel *Describe = new QLabel(this,klocale->translate("For ASCII import, KVideolist will use the rules You defined in the configuration\ndialog. If You did not defined one yet, please read the online help."),this);
	Describe->adjustSize();
	Describe->move(10,200);

	Target = new QLineEdit(this,"target");
	Target->resize(214,25);Target->move(260,154);
	
	QPushButton *OK = new QPushButton(klocale->translate("Ok"),this);
	QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
	OK->move(20,255);
	Cancel->move(300,255);

	connect(OK,SIGNAL(clicked()),SLOT(slotOKPressed()));
	connect(Cancel,SIGNAL(clicked()),SLOT(slotCancelPressed()));
	connect(Filechange,SIGNAL(clicked()),SLOT(slotFileChange()));
	connect(Filename,SIGNAL(textChanged(const char *)),SLOT(slotTextChanged()));
};

void Importer::slotFileChange() {
	QString s=QFileDialog::getOpenFileName(0,"*.*",this);
	Filename->setText(s);
	};
void Importer::slotTextChanged() {
	char Dummy[255];
	strcpy(Dummy,"NEW");
	
	if (Version->currentItem()==0) { strcpy(Dummy,"imported.kvl");};
	if (Version->currentItem()==1) { strcpy(Dummy,"imported.kvl");};
	Target->setText(Dummy);

	
	Target->show();	
	};
void Importer::slotOKPressed() {
	  FILE *Test;
                if ((Test=fopen(Filename->text(),"rb"))==NULL) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The file You selected does not exist."));return;};     	
	if (strlen(Filename->text())==0) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("No filename given."));return;};
	if (strlen(Target->text())==0) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Enter a target filename."));return;};


QApplication::setOverrideCursor(waitCursor);


	char File[255];
	char TargetC[255];
	strcpy(File,Filename->text());
	strcpy(TargetC,Target->text());
KConfig *config=KApplication::getKApplication()->getConfig();
char Positions[255];
char Pattern[255];
strcpy(Positions,config->readEntry("ASCIIIMPORT"));
strcpy(Pattern,config->readEntry("SEPARATOR"));

if (Version->currentItem()==0) { asc2kvl(File,TargetC,Positions,Pattern);};








QApplication::restoreOverrideCursor();
QMessageBox::information(this,klocale->translate("Status"),klocale->translate("File import finished."));
 	
	accept();
	};
void Importer::slotCancelPressed() {
	reject();
	};


	
