/***************************************************************************
                          data.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include <stdlib.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <kapp.h>
#include "data.h"

// extern struct GridSettingsType GridDefaults;

DataFile::DataFile(const char *Name) {
int Lauf,Count;

   DN = Name;
   // Endung entfernen, wenn bereits Dataendung
   if (DN.right(4) == EXT_DATA)
      DN.resize(DN.length()-3);
   Active = FALSE;
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      DataArr[Lauf]=NULL;
      for (Count=0; Count<MAXCOUNT; Count++)
         DPTR[Count][Lauf]=NULL;
   }
   Offset=0;
   DataSize=0;
   FilePos=0;
   RecordCount=0;
   debug("Dateiname=%s",DN.data());
   DisplayBits=NULL;
}

DataFile::~DataFile(void) {
  if (Active)
    fclose(DF);
  if (DisplayBits)
    free(DisplayBits);
      
  Active=FALSE;
}

int DataFile::CreateNewFile(DataArrType* DA, short Mon, short Jahr, struct GridSettingsType* GS) {
// Es wird eine neue Datei erzeugt.
// Die Dateidefinition wird aus einem Array DataArrType gelesen,
// auf das der Parameter DA zeicht.
// Rckgabe TRUE, wenn Datei erfolgreich angelegt wurde
//         FALSE, wenn datei nicht angelegt wurde (zB. vorh. Datei nicht berschreiben)
int Lauf,Count;
FILE *DF;
QString DataFile, Msg;
MonatHeaderType MonHeader;
ShortDataType SData;
FloatDataType FData;
LongDataType LData;
ValidDataType VData;
HeaderDef HD;

   debug("CreateHeader");
   DataFile = DN+EXT_DATA;
   debug("Datafile=%s",DataFile.data());
   
   // berschreiben nachfragen
   if (QFile::exists(DataFile.data())) {
      Msg = i18n("Overwrite File ")+DN;
      if (QMessageBox::warning ( NULL,  i18n("File Overwrite"), Msg.data(), 
               i18n("Yes"), i18n("No"), 0, 
               0, -1 ) == 1)
         return FALSE; // nicht berschreiben
   }
   
   // Anzahl der DS ermitteln
   for (Count=0; Count<MAXDATA; Count++)
      if ((*DA)[Count]==NULL) break;


   // DisplayBits initialisieren
   // Default ist: Linientypen sichtbar, alles andere nicht
   DisplayBits = (IPtr)malloc(sizeof(IType)*Count);
   if (!DisplayBits) {
     return FALSE;  // kein Speicher....
   }
   memset(DisplayBits,0,sizeof(IType)*Count);
   // Inisialisierung
   for (Lauf=0; Lauf<Count; Lauf++) {
     if ((*DA)[Lauf])
     switch ( (*DA)[Lauf]->Type) {
       case TYP_LINE:
       case TYP_PRESSURE:
       case TYP_LEVEL:     // sichtbar setzen
                           (*DisplayBits[Lauf]).BF1.Display = TRUE;
                           debug("sichtbar");
                           break;
       default:            // unsichtbar setzen
                           (*DisplayBits[Lauf]).BF1.Display = FALSE;
                           debug("unsichtbar");
     }
   }

   DF = fopen(DataFile.data(), "wb");
   if (!DF) {
     free(DisplayBits);
     return FALSE; //DTA_CREATEERROR;
   }
   
   // Header schreiben
   strncpy(HD.Kennung,KENNDATA,12);
   HD.Count=Count;
   memcpy(&(HD.GS), GS, sizeof(struct GridSettingsType));
   debug ("Count=%d",Count);
   fwrite(&HD, sizeof (struct HeaderDef), 1, DF);
   debug("sizeof(headerdef)=%d",sizeof (struct HeaderDef));

   // Displaybits schreiben
   fwrite(DisplayBits, sizeof(IType)*Count, 1, DF);

   // Definitionsdatenstze schreiben
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if ((*DA)[Lauf]==NULL) break;
      debug("Name:%s  Count:%d",(*DA)[Lauf]->Name,(*DA)[Lauf]->Count);
      fwrite((*DA)[Lauf], sizeof(struct DataDef), 1, DF);
      debug("sizeof(datadef)=%d",sizeof (struct DataDef));
   }
   
   // Anfangsdatum schreiben
   MonHeader.Monat = Mon;
   MonHeader.Jahr = Jahr;

   // leere Datenpuffer initialisieren
   for (Lauf=0; Lauf<31; Lauf++) {
      SData[Lauf]=0;
      LData[Lauf]=0;
      FData[Lauf]=0.0;
   }

   fwrite(&MonHeader, sizeof(MonHeader), 1, DF);
   debug("sizeof(monheader)=%d",sizeof (MonHeader));
   debug("M=%d  J=%d",Mon,Jahr);

   // einen Datensatz schreiben
   VData[0]=0;VData[1]=0;VData[2]=0;VData[3]=0;
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if ((*DA)[Lauf]==NULL) break; //Erster NULL-Zeiger, keine weiteren Daten
      //debug("Count=%d",(*DA)[Lauf]->Count);
      for (Count=0; Count<(*DA)[Lauf]->Count; Count++) {
         // Validbits schreiben
         if ( (*DA)[Lauf]->Type!=TYP_GROUP) {
            fwrite(VData,sizeof(ValidDataType),1,DF);
         }
         switch ( (*DA)[Lauf]->Type ) {
            case TYP_GROUP    : break;
            case TYP_PRESSURE : 
            case TYP_LINE     : 
            case TYP_LEVEL    : fwrite(&FData, sizeof(FData), 1, DF);
                                break;
            case TYP_WEATHER  :
                                fwrite(&SData, sizeof(SData), 1, DF);
                                //debug("write data");
                                break;
            case TYP_WIND     : fwrite(&LData, sizeof(LData),1, DF);
                                break;
            /*case TYP_TEXT     : {
                                char * sptr;
                                int i;
                                
                                   sptr = (char*)malloc((*DA)[Lauf]->Count);
                                   memset(sptr, 0, (*DA)[Lauf]->Count);
                                   for (i=0;i<31;i++)
                                      fwrite(sptr,(*DA)[Lauf]->Count, 1, DF);
                                   free(sptr);
                                   //debug("write data %ld",(*DA)[Lauf]->Scale);
                                }
                                break;*/
         }
      }
   }
   fclose(DF);
   
   return TRUE;
}

int DataFile::Open(struct GridSettingsType* GS) {
QString Daten;
DataPtr New;
int Posi, Cnt, Lauf, GrpMerk;
HeaderDef HD;
MonatHeaderType MH;

   // evtl. offene Datei schlieen
   if (Active) {
      Close();
      ClearDataArr();
   }
   
   // Existenz der Header- und Datendatei prfen
   Daten=DN+EXT_DATA;
   if (!QFile::exists(Daten))
      return DTA_FILENOTFOUND;
   
   debug("Daten=%s",Daten.data());
   DF = fopen(Daten, "r+b");
   if (!DF) 
      return DTA_OPENERROR;
      
   // Dateikenndatensatz lesen
   fread(&HD, sizeof(struct HeaderDef), 1, DF);
//   debug("Kenn=%s, count=%d",HD.Kennung,HD.Count);
   if (strncmp(KENNDATA, HD.Kennung, 12)!=0) {
      debug("Keine KWeather-Datei");
      return DTA_INVALIDFILE;
   }
   if (HD.Count>=MAXDATA) {
      debug("Too many dataitems(%d), file unusable with this version. Increase MAXDATA constant in data.h",HD.Count);
      fclose(DF);
      ClearDataArr();
      return DTA_ERROR;
   }
   memcpy(GS, &(HD.GS), sizeof(struct GridSettingsType));

   // Displaybits lesen;
   DisplayBits = (IPtr)malloc(sizeof(IType)*HD.Count);
   if (!DisplayBits) {
     fclose(DF);
     ClearDataArr();
     return DTA_ERROR;  // kein Speicher
   }
   fread(DisplayBits, sizeof(IType)*HD.Count,1, DF);

   // Einlesen der Dateidefinition (Header)
   // Einlesen der Definitionsstze
   Posi=0;
   for (Posi=0; Posi<HD.Count; Posi++) {
      New=(DataPtr)malloc(sizeof(struct DataDef));
      fread(New, sizeof(struct DataDef), 1, DF);
      debug("Item Nr=%d  name=%s",Posi, New->Name);
      DataArr[Posi]=New;
   }
   
   // Startmonat lesen
   Posi=fread(&MH, sizeof(MH), 1, DF);
   Monat=MH.Monat;
   Jahr=MH.Jahr;
   debug("M=%d  J=%d",Monat,Jahr);
   debug("fread res=%d",Posi);
   debug("filepos=%ld",ftell(DF));
   
   Offset=sizeof(struct HeaderDef)
         +HD.Count*sizeof(struct DataDef)
         +sizeof(MH)
         +sizeof(IType)*HD.Count;  // Displaybits
   debug("Offset=%ld",Offset);
   
   // Anlegen der Datenpuffer
   DataSize=0;
   for (Posi=0; Posi<MAXDATA; Posi++) {
      if (DataArr[Posi]!=NULL) {
         for (Cnt=0; Cnt<DataArr[Posi]->Count; Cnt++) {
            switch(DataArr[Posi]->Type) {
               case TYP_GROUP : break;
               case TYP_LINE  :
               case TYP_PRESSURE  :
               case TYP_LEVEL : DPTR[Cnt][Posi]=(FloatDataType*)malloc(sizeof(FloatDataType));
                                DataSize=DataSize+sizeof(FloatDataType)+sizeof(ValidDataType);
                                break;
               case TYP_TEXT  :
                                break;
               case TYP_WIND  : DPTR[Cnt][Posi]=(LongDataType*)malloc(sizeof(LongDataType));
                                DataSize=DataSize+sizeof(LongDataType)+sizeof(ValidDataType);
                                break;
               default        : DPTR[Cnt][Posi]=(ShortDataType*)malloc(sizeof(ShortDataType));
                                DataSize=DataSize+sizeof(ShortDataType)+sizeof(ValidDataType);
                                break;
            }
         }
      }
   }
   Active=TRUE;
   fseek(DF,0,SEEK_END);
   RecordCount=ftell(DF);
   RecordCount=(RecordCount-Offset)/DataSize;  // Anzahl der Datenstze
   
   ItemCount=0;
   memset(ZA,0,sizeof(ZA));
   memset(ZH,0,sizeof(ZH));
   GrpMerk=0;
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DataArr[Lauf]!=NULL) 
      if (DataArr[Lauf]->Type != TYP_GROUP) {  // Dateneintrag
         ZA[ItemCount]=Lauf;
         ZH[ItemCount]=GrpMerk;
         ItemCount++;
      } else
         GrpMerk=Lauf;
   }
debug("ItemCount=%d",ItemCount);
for (Lauf=0;Lauf<ItemCount;Lauf++) debug("ZA[%2d]=%2d   ZA[%2d]=%2d",Lauf,ZA[Lauf],Lauf,ZH[Lauf]);

   debug("recordCount=%ld",RecordCount);
   debug("DataSize=%ld",DataSize);
   debug("Open Ende");
   return DTA_OK;
}

int DataFile::Close(void) {
  if (Active)
    fclose(DF);
  if (DisplayBits)
    free(DisplayBits);
  DisplayBits=NULL;
  Active=FALSE;
  return DTA_OK;
}

void DataFile::ClearDataArr(void) {
int Lauf,Count;

   if (Active)
      Close();
      
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DataArr[Lauf]!=NULL)
         free(DataArr[Lauf]);
      for (Count=0; Count<MAXCOUNT; Count++)
         if (DPTR[Count][Lauf]!=NULL) {
            free(DPTR[Count][Lauf]);
            DPTR[Count][Lauf]=NULL;
         }
      DataArr[Lauf]=NULL;
   }
}

int DataFile::Seek(short M, short J) {
// Monat, Jahr vorwhlen
int Base, Ret;

//debug("Seek-Start");
   if (!Active)
      return DTA_FILENOTOPEN;
   
   Base = Monat+12*Jahr;
   FilePos = (M+12*J)-Base;
   if (FilePos<0) FilePos=0;
   
   Base = Offset+FilePos*DataSize;
   Ret=fseek(DF, Base, SEEK_SET);
   if (FilePos<20)
      debug("Base=%d  FilePos=%ld   Ret=%d",Base,FilePos,Ret);
   
   if (Ret==0)
      return DTA_OK;
   else
      return DTA_ERROR;
}

int DataFile::Seek(int RecNo) {
// Datensatz mit Nummer whlen
long int Pos;
int Ret;

   if (!Active)
      return DTA_FILENOTOPEN;

   Pos=Offset+RecNo*DataSize;
   Ret=fseek(DF, Pos, SEEK_SET);
   FilePos=RecNo;
   
   if (Ret==0)
      return DTA_OK;
   else
      return DTA_ERROR;
}

int DataFile::Read(void) {
// Datensatz lesen
int Lauf, Count;


   // einen Datensatz lesen
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DataArr[Lauf]==NULL) break; //Erster NULL-Zeiger, keine weiteren Daten
      //debug("Count=%d",DataArr[Lauf]->Count);
      for (Count=0; Count<DataArr[Lauf]->Count; Count++) {
         // Validbits lesen
         if (DataArr[Lauf]->Type!=TYP_GROUP) {
            fread(VDTA[Count][Lauf],sizeof(ValidDataType),1,DF);
            debug("%lX\n%lX\n%lX\n%lX",VDTA[Count][Lauf][0],
               VDTA[Count][Lauf][1],
               VDTA[Count][Lauf][2],
               VDTA[Count][Lauf][3]);
         }
         switch ( DataArr[Lauf]->Type ) {
            case TYP_GROUP    : break;
            case TYP_PRESSURE : 
            case TYP_LINE     : 
            case TYP_LEVEL    : fread(DPTR[Count][Lauf], sizeof(FloatDataType), 1, DF);
                                //debug("read data");
                                break;
            case TYP_WEATHER  : fread(DPTR[Count][Lauf], sizeof(ShortDataType), 1, DF);
                                //debug("read data");
                                break;
            case TYP_WIND     : fread(DPTR[Count][Lauf], sizeof(LongDataType), 1, DF);
                                break;
            case TYP_TEXT     : /* spter...
                                {
                                int i;
                                
                                   for (i=0;i<31;i++)
                                      fread(sptr,(*DA)[Lauf]->Scale, 1, DF);
                                   debug("read data %ld",(*DA)[Lauf]->Scale);
                                }*/
                                break;
         }
      }
   }

   /*{  // Testausgabe "Morgens"
   ShortDataType* SD;
      SD=(ShortDataType*)(DPTR[0][1]);
      for (Lauf=0; Lauf<10; Lauf++) {
         debug("M[%d] = %0.1f",Lauf, (*SD)[Lauf]*0.1);
      }
   }
   {  // Testausgabe "Wetter"
   ShortDataType* SD;
      SD=(ShortDataType*)(DPTR[0][4]);
      for (Lauf=0; Lauf<10; Lauf++) {
         debug("W[%d] = %d",Lauf, (*SD)[Lauf]);
      }
   }*/

   return DTA_OK;
}

int DataFile::Write(void) {
//  Datensatz speichern
int Lauf, Count;

   // einen Datensatz schreiben (an der aktuellen Position)
   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DataArr[Lauf]==NULL) break; //Erster NULL-Zeiger, keine weiteren Daten
      //debug("Count=%d",DataArr[Lauf]->Count);
      for (Count=0; Count<DataArr[Lauf]->Count; Count++) {
         // Validbits schreiben
         if (DataArr[Lauf]->Type!=TYP_GROUP) {
            //VDTA[Count][Lauf][0]=0x12345678;
            //VDTA[Count][Lauf][1]=0x23456789;
            //VDTA[Count][Lauf][2]=0x34567890;
            //VDTA[Count][Lauf][3]=0x45678901;
            fwrite(VDTA[Count][Lauf],sizeof(ValidDataType),1,DF);
         }
         switch ( DataArr[Lauf]->Type ) {
            case TYP_GROUP    : break;
            case TYP_PRESSURE : 
            case TYP_LINE     : 
            case TYP_LEVEL    : fwrite(DPTR[Count][Lauf], sizeof(FloatDataType), 1, DF);
                                //debug("write data");
                                break;
            case TYP_WEATHER  : fwrite(DPTR[Count][Lauf], sizeof(ShortDataType), 1, DF);
                                //debug("write data");
                                break;
            case TYP_WIND     : fwrite(DPTR[Count][Lauf], sizeof(LongDataType), 1, DF);
                                break;
            case TYP_TEXT     : /* spter...
                                {
                                int i;
                                
                                   for (i=0;i<31;i++)
                                      fwrite(sptr,(*DA)[Lauf]->Scale, 1, DF);
                                   debug("write data %ld",(*DA)[Lauf]->Scale);
                                }*/
                                break;
         }
      }
   }

   return DTA_OK;
}

int DataFile::Clear(void) {
//  Datensatz initialisieren
int Lauf, Count;

   // Initialisierung
   memset(VDTA,0,sizeof(VDTA));

   for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DataArr[Lauf]==NULL) break; //Erster NULL-Zeiger, keine weiteren Daten
      //debug("Count=%d",DataArr[Lauf]->Count);
      for (Count=0; Count<DataArr[Lauf]->Count; Count++) {
         switch ( DataArr[Lauf]->Type ) {
            case TYP_GROUP    : break;
            case TYP_PRESSURE : 
            case TYP_LINE     : 
            case TYP_LEVEL    : memset(DPTR[Count][Lauf],0,sizeof(FloatDataType));
                                break;
            case TYP_WEATHER  : memset(DPTR[Count][Lauf],0,sizeof(ShortDataType));
                                break;
            case TYP_WIND     : memset(DPTR[Count][Lauf],0,sizeof(LongDataType));
                                break;
            case TYP_TEXT     : /* spter...*/
                                break;
         }
      }
   }

   return DTA_OK;
}

int DataFile::GetCurrentMon(void) {
// Datum des letzten Eintrages (Jahr)
int Cnt;

   Cnt=Monat+12*Jahr+FilePos-1;
   debug("GetCurrentMon: FilePos=%ld,  Cnt=%d",FilePos,Cnt);
   return Cnt % 12;
}

int DataFile::GetCurrentYear(void) {
// Datum des letzten Eintrages (Jahr)
int Cnt;

   Cnt=Monat+12*Jahr+FilePos-1;
   debug("GetCurrentYear: FilePos=%ld,  Cnt=%d",FilePos,Cnt);
   return Cnt / 12;
}

/*int DataFile::GetLastMon(void) {
// Datum des letzten Eintrages (Monat)

   fseek(DF,0,SEEK_END);
   RecordCount=ftell(DF);
   RecordCount=(RecordCount-Offset)/DataSize;  // Anzahl der Datenstze
   
}

int DataFile::GetLastYear(void) {
// Datum des letzten Eintrages (Jahr)
   return 0;
}*/

int DataFile::GetValid(long int Vld, int Bit) {
// Valid-Bit prfen

//debug("%d\n%d",1 << Bit, Vld);
  return (Vld & (1 << Bit));
}

void DataFile::SetValid(long int * Vld, int Bit, int Set) {
// Valid-Bit ndern
long int Mask;

  Mask=1 << Bit;
  if (Set) {
    *Vld = *Vld | Mask;
  } else {
    *Vld = *Vld & ~Mask;
  }
}

void DataFile::ValidTestAus(long int v) {
int i;
QString S;

  S="";
  for (i=31;i>=0;i--)
    if (GetValid(v,i))
      S+="1";
    else
      S+="0";
  debug("%s",S.data());
}

// DisplayBits
void DataFile::SetVisible(int Nr, int Dsp) {
// Display-Bit gezielt setzen/zurcksetzen
  if (!DataArr[Nr]) {
    debug("SetVisible: Nr (%d) out of range", Nr);
    return;
  }
  if (Dsp) {  // sichtbar schalten - Bit zurcksetzen
    (*DisplayBits[Nr]).BF1.Display = TRUE;
  } else {
    (*DisplayBits[Nr]).BF1.Display = FALSE;
  }
}

int DataFile::IsVisible(int Nr) {
// Display-Bit abfragen
  if (!DataArr[Nr]) {
    debug("SetVisible: Nr (%d) out of range", Nr);
    return FALSE;
  }

  if ( (*DisplayBits[Nr]).BF1.Display)
    return TRUE;   // sichtbar
  else
    return FALSE;  // nicht sichtbar
}

int DataFile::SaveVisibleBits(void) {
// visiblebits in Datei speichern
int Ofs;
HeaderDef HD;

  if (!Active) return DTA_FILENOTOPEN;

  fseek(DF,0,SEEK_SET);
  fread(&HD, sizeof(struct HeaderDef), 1, DF);

  Ofs= sizeof(struct HeaderDef);
      //+HD.Count*sizeof(struct DataDef)
      //+sizeof(MonatHeaderType);
  fseek(DF, Ofs, SEEK_SET);
  fwrite(DisplayBits, sizeof(IType)*HD.Count,1, DF);
  return DTA_OK;
}

int DataFile::LoadVisibleBits(void) {
// visiblebits aus Datei lesen
int Ofs;
HeaderDef HD;

  if (!Active) return DTA_FILENOTOPEN;

  fseek(DF,0,SEEK_SET);
  fread(&HD, sizeof(struct HeaderDef), 1, DF);

  Ofs= sizeof(struct HeaderDef);
      //+HD.Count*sizeof(struct DataDef)
      //+sizeof(MonatHeaderType);
  fseek(DF, Ofs, SEEK_SET);
  fread(DisplayBits, sizeof(IType)*HD.Count,1, DF);

  return DTA_OK;
}
