/***************************************************************************
                          dlgedit.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdlib.h>
#include <math.h>
#include <qlabel.h>
#include <kbutton.h>
#include <qregexp.h>
#include "dlgedit.h"
#include "dlgdata.h"
#include "globals.h"
#include "dlgw.h"

#define STK_LINEED 1
#define STK_WINDROSE 2
#define STK_WETTER 3

#define ED_FIRST 1
#define ED_LEFT  2
#define ED_RIGHT 3
#define ED_LAST  4

EditDlg* edlg;
extern PixPtr WetterIcon[256];  // Icon fr die Tageswetterlage
extern DataDlg* ddlg;

// EditDlg::EditDlg(DataFile* DFile, TChart* TC, const char* name=0):
//  KTMainWindow(name)
EditDlg::EditDlg(DataFile* DFile, TChart* TC, const char* name):
  QDialog(NULL, name, TRUE, 0 )
{

   setGeometry(300,0,300,200);
   //setMinimumSize(100,100);
   setFixedSize(300,200);
   Chart = TC;
   Tag=Chart->DispTag;
   Item=0;
   MaxTag=Chart->MTage();
   Count=0;
   DF=DFile;

   setCaption(i18n("Edit Data"));


   EditFrm=new QFrame(this);
   EditFrm->setGeometry(10,100,150,100);
   LEdit = new QLineEdit(EditFrm);   // Editzeile
   LEdit->setGeometry(5,5,80,22);
   EditEinheitLab = new QLabel("", EditFrm);
   EditEinheitLab->setGeometry(90,5,50,20);
   EditFrm->hide();

   WindFrm=new QFrame(this);
   WindFrm->setGeometry(10,100,170,100);
   KW=new KWindRose(WindFrm);        // Windrichtung
   KW->setDetails(1);
   KW->setArrowType(KWindRose::ARROW2);
   KW->setGeometry(5,5, 70,70);
   KW->setResolution(22.5); //(11.25);
   WSEdit = new QLineEdit(WindFrm);
   WSEdit->setGeometry(90,30,50,22);
   WindEinheitLab = new QLabel("", WindFrm);
   WindEinheitLab->setGeometry(145,30,50,20);
   WindRichtungLab = new QLabel("", WindFrm);
   WindRichtungLab->setGeometry(30,85,50,15);
   connect(KW, SIGNAL(valueChanged(float)), this, SLOT(KWRValueChange(float)));

   WetterFrm=new QFrame(this);
   WetterFrm->setGeometry(10,100,150,100);
   WetterBtn = new QPushButton(WetterFrm, "Wetter");  // Icon
   WetterBtn->setGeometry(5,5,35,35);
   WetterEdit=new QLineEdit(WetterFrm);
   WetterEdit->setGeometry(50,7, 40,22);
   connect(WetterEdit, SIGNAL(textChanged(const char*)), this, SLOT(WetterEditChange(const char*)));
   connect(WetterBtn, SIGNAL(clicked()), this, SLOT(WetterBtnClick()));

   QLabel* TgLab=new QLabel(i18n("Day"), this);
   TgLab->setGeometry(10,30, 80,15);
   QLabel* GrLab=new QLabel(i18n("Group"), this);
   GrLab->setGeometry(10,45, 80,15);
   QLabel* ItLab=new QLabel(i18n("Item"), this);
   ItLab->setGeometry(10,60, 80,15);
   QLabel* VtLab=new QLabel(i18n("Previous"), this);
   VtLab->setGeometry(10,80, 80,15);

   TagLab = new QLabel(i18n("Day"), this);
   TagLab->setGeometry(95,30,150,15);
   GroupLab = new QLabel(i18n("Group"), this);
   GroupLab->setGeometry(95,45,150,15);
   ItemLab = new QLabel(i18n("Item"), this);
   ItemLab->setGeometry(95,60,150,15);
   PreviousLab = new QLabel(i18n("Previous"), this);
   PreviousLab->setGeometry(95,80,150,15);

   //CloseBtn = new QPushButton(i18n("Close"), this, "CloseBtn");
   //CloseBtn->setGeometry(210,160,80,30);
   //connect(CloseBtn, SIGNAL(clicked()), SLOT(CloseBtnClick()));

   SetupToolBar();

   UpdateHeader();
   DisplayData();
}

/*int EditDlg::Aktualisieren(void) {
   if (isVisible()) {
      debug("Aktualisieren - is visible");
      Tag=Chart->DispTag;
      Item=0;
      MaxTag=Chart->MTage();
      Count=0;
      DisplayData();
   } else {
      debug("Aktualisieren - nonvisible");
   }
   return TRUE;
}*/

void EditDlg::PrevBtnClick() {
   //debug("PrevBtnClick");
   StoreData();
   if (Count>0) {
      Count--;
   } else {
      if (Item>0) {
         Item--;
         Count=DF->DataArr[ DF->ZA[Item] ]->Count-1;
      } else {
         if (Tag>0) {
            Tag--;
            Item=DF->ItemCount-1;
            Count=DF->DataArr[ DF->ZA[Item] ]->Count-1;
            Chart->UpdateTag(Tag);
         }
      }
   }
   UpdateHeader();
   DisplayData();
   ddlg->Aktualisieren(Tag);
//debug("Tag=%2d, Item=%2d, Count=%2d",Tag,Item,Count);
}

void EditDlg::NextBtnClick() {
   debug("NextBtnClick");
   StoreData();
   if (Count<DF->DataArr[ DF->ZA[Item] ]->Count-1) {
      Count++;
   } else {
      if (Item<DF->ItemCount-1) {
         Item++;
         Count=0;
      } else {
         if (Tag<MaxTag-1) {
            Tag++;
            Item=0;
            Count=0;
            Chart->UpdateTag(Tag);
         }
      }
   }
   UpdateHeader();
   DisplayData();
   ddlg->Aktualisieren(Tag);
debug("Tag=%2d, Item=%2d, Count=%2d",Tag,Item,Count);
}

void EditDlg::FirstBtnClick() {
   //debug("FirstBtnClick");
   StoreData();
   Tag=0;
   Item=0;
   Count=0;
   UpdateHeader();
   DisplayData();
   Chart->UpdateTag(Tag);
}

void EditDlg::LastBtnClick() {
   //debug("LastBtnClick");
   StoreData();
   Tag=MaxTag-1;
   Item=DF->ItemCount-1;
   Count=DF->DataArr[ DF->ZA[Item] ]->Count-1;
   UpdateHeader();
   DisplayData();
   Chart->UpdateTag(Tag);
}

void EditDlg::AbortBtnClick() {
   if(QMessageBox::warning(this, i18n("Data Changed"), i18n("Cancel Modificated Data"),
                    i18n("Yes"), i18n("No"), 0, 0, 1)==0)
      reject();
}

void EditDlg::OkBtnClick() {
   StoreData();
   accept();
}

void EditDlg::SetupToolBar()
{
  KIconLoader IconLoader;
/*  ToolBar = new KToolBar(this);

//  addToolBar(ToolBar);

#define I(f,i,o,s,h) ToolBar->insertButton( iconLoader.loadIcon(f),\
	 i, SIGNAL(clicked()), o, SLOT(s()), TRUE, h);

  I("kt_hide.xpm",  0,        this, CloseBtnClick, i18n("Hide Window"));
  ToolBar->insertSeparator();
  I("pfeil_lf.xpm", ED_FIRST, this, FirstBtnClick, i18n("First"));
  I("pfeil_l.xpm",  ED_LEFT , this, PrevBtnClick,  i18n("Prev"));
  I("pfeil_r.xpm",  ED_RIGHT, this, NextBtnClick,  i18n("Next"));
  I("pfeil_rf.xpm", ED_LAST , this, LastBtnClick,  i18n("Last"));

#undef I
*/

   QFrame* TopPnl=new QFrame(this);
   TopPnl->setGeometry(0,0, width(), 26);
   TopPnl->setFrameStyle(QFrame::Panel | QFrame::Raised);

   KButton *AbortBtn = new KButton(TopPnl);
   AbortBtn->setGeometry(5,1,24,24);
   AbortBtn->setPixmap(IconLoader.loadIcon("kt_hide.xpm"));
   connect(AbortBtn,SIGNAL(clicked()),   this,SLOT(AbortBtnClick()));

   KButton *OkBtn = new KButton(TopPnl,"TESTtest");
   OkBtn->setGeometry(35,1,24,24);
   OkBtn->setPixmap(IconLoader.loadIcon("kt_ok.xpm"));
   connect(OkBtn,SIGNAL(clicked()),   this,SLOT(OkBtnClick()));

   KButton *FirstBtn = new KButton(TopPnl);
   FirstBtn->setGeometry(65,1,24,24);
   FirstBtn->setPixmap(IconLoader.loadIcon("pfeil_lf.xpm"));
   connect(FirstBtn,SIGNAL(clicked()),   this,SLOT(FirstBtnClick()));

   KButton *PrevBtn = new KButton(TopPnl);
   PrevBtn->setGeometry(95,1,24,24);
   PrevBtn->setPixmap(IconLoader.loadIcon("pfeil_l.xpm"));
   connect(PrevBtn,SIGNAL(clicked()),   this,SLOT(PrevBtnClick()));

   KButton *NextBtn = new KButton(TopPnl);
   NextBtn->setGeometry(125,1,24,24);
   NextBtn->setPixmap(IconLoader.loadIcon("pfeil_r.xpm"));
   connect(NextBtn,SIGNAL(clicked()),   this,SLOT(NextBtnClick()));

   KButton *LastBtn = new KButton(TopPnl);
   LastBtn->setGeometry(155,1,24,24);
   LastBtn->setPixmap(IconLoader.loadIcon("pfeil_rf.xpm"));
   connect(LastBtn,SIGNAL(clicked()),   this,SLOT(LastBtnClick()));
}

void EditDlg::UpdateHeader() {
char S[80];

   sprintf(S,"%d",Tag+1);
   TagLab->setText(S);
   sprintf(S,"%s",DF->DataArr[ DF->ZH[Item] ]->Name);
   GroupLab->setText(S);

   sprintf(S,"%s %02d:%02d",DF->DataArr[ DF->ZA[Item] ]->Name, 
               DF->DataArr[ DF->ZA[Item] ]->Times[Count]/60,
               DF->DataArr[ DF->ZA[Item] ]->Times[Count]%60);
   ItemLab->setText(S);
   if (Tag==0) {
     PreviousLab->setText("-");
   } else {
     ShortDataType *SD;
     FloatDataType *FD;
     LongDataType* LD;

     int Valid1 = DF->GetValid(DF->VDTA[Count][DF->ZA[Item]][0],Tag-1);
     int Valid2 = DF->GetValid(DF->VDTA[Count][DF->ZA[Item]][1],Tag-1);

     strcpy(S,"-");
     switch (DF->DataArr[ DF->ZA[Item] ]->Type ) {
       case TYP_LINE:
       case TYP_PRESSURE: if (Valid1) {
                            FD=(FloatDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                            sprintf(S,"%0.1f %s", (*FD)[Tag-1], DF->DataArr[ DF->ZA[Item] ]->Einheit);
                          }
                          break;
       case TYP_LEVEL:    if (Valid1) {
                            FD=(FloatDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                            sprintf(S,"%0.0f %s", (*FD)[Tag-1], DF->DataArr[ DF->ZA[Item] ]->Einheit);
                          }
                          break;
       case TYP_WEATHER:  if (Valid1) {
                            SD=(ShortDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                            sprintf(S,"%d", (*SD)[Tag-1]);
                          }
                          break;
       case TYP_WIND:     if (Valid2) {
                            KWindRose kwr;
                            LD=(LongDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                            //strcpy(S,kwr.directionToText((((*LD)[Tag-1]) & 0x0000FFFF)*0.1), 3);
                            if (Valid1)
                              sprintf(S,"%s %0.1f %s",kwr.directionToText(((((*LD)[Tag-1]) & 0x0000FFFF)*0.1),3),
                                                        ((((*LD)[Tag-1])>>16)& 0x0000FFFF)*0.1,
                                                         DF->DataArr[ DF->ZA[Item] ]->Einheit2 );
                            else
                              sprintf(S,"%s",kwr.directionToText(((((*LD)[Tag-1]) & 0x0000FFFF)*0.1),3) );
                            debug("tag=%d,  %s",Tag-1,S);
                          }
                          break;
     }
     PreviousLab->setText(S);
   }
}

void EditDlg::DisplayData() {
// Anzeige der Daten, Anpassen des Widgetstack, 
int Type, T, W, WS, WR;
char S[20];
ShortDataType *SD;
FloatDataType *FD;
LongDataType* LD;
int Valid1,Valid2;

   debug ("Displaydata: Tag=%d,  Item=%d, Count=%d",Tag,Item,Count);
//debug("ZA=%d",DF->ZA[Item]);
//debug("DPTR=%p",DF->DPTR[DF->ZA[Count]][Item]);

   Type=DF->DataArr[ DF->ZA[Item] ]->Type;
   Valid1 = DF->GetValid(DF->VDTA[Count][DF->ZA[Item]][0],Tag);
   Valid2 = DF->GetValid(DF->VDTA[Count][DF->ZA[Item]][1],Tag);
   switch (Type) {
      case TYP_LINE :    
      case TYP_LEVEL :    
      case TYP_PRESSURE: EditFrm->show();
                         WetterFrm->hide();
                         WindFrm->hide();
                         EditEinheitLab->setText(DF->DataArr[DF->ZA[Item]]->Einheit);
                         FD=(FloatDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                         //T = (*FD)[Tag];
                         //if (Type==TYP_PRESSURE)
                         //   T+=10000;

                         //if (DF->GetValid(DF->VDTA[Count][DF->ZA[Item]][0],Tag)) {
                         if (Valid1) {
                           //if (Type == TYP_LEVEL)
                           //  sprintf(S,"%d", T);
                           //else
                             sprintf(S,"%0.1f", (*FD)[Tag]);
                         } else
                           //sprintf(S,"");
                           strcpy(S,"");
                         LEdit->clearFocus();
                         LEdit->setText(S);
//                         LEdit->setSelection(0, strlen(S));
                         LEdit->setSelection(0, 10);
                         LEdit->setFocus();
                         break;

      case TYP_WEATHER : EditFrm->hide();
                         WetterFrm->show();
                         WindFrm->hide();
                         if (Valid1) {
                           SD=(ShortDataType*)(DF->DPTR[Count][DF->ZA[Item]]);
                           T=(*SD)[Tag];
                           if (WetterIcon[T] == NULL) {
                             WetterIcon[T] = new QPixmap(CalcWetterImage(T));
                           }
                           WetterBtn->setPixmap(*(WetterIcon[T]));
                           sprintf(S,"%d",T);
                         } else
                           strcpy(S,"");
                         WetterEdit->setText(S);
                         WetterEdit->setSelection(0, strlen(S));
                         WetterEdit->setFocus();
                         break;

      case TYP_WIND :    EditFrm->hide();
                         WetterFrm->hide();
                         WindFrm->show();
                         WindEinheitLab->setText(DF->DataArr[DF->ZA[Item]]->Einheit2);
                         LD=(LongDataType*)(DF->DPTR[Count][DF->ZA[Item]]);
                         W=(*LD)[Tag];
                         WR=W & 0x0000FFFF;
                         WS=(W>>16) & 0x0000FFFF;

                         if (Valid2) {
                           if ( (WR>65000) || (WR<0) ) {
                             KW->setDirection(0);
                             KW->setValid(KWR_NODIR);
                             WindRichtungLab->setText("-");
                           } else {
                             KW->setDirection(0.1*WR);
                             KW->setValid(KWR_VALID);
                             WindRichtungLab->setText(KW->directionToText());
                           }
                         } else {
                           KW->setDirection(0);
                           KW->setValid(KWR_INVALID);
                           WindRichtungLab->setText("-");
                         }

                         if (Valid1) {
                           sprintf(S,"%0.1f",0.1*WS);
                           WSEdit->setText(S);
                           WSEdit->setSelection(0, strlen(S));
                         } else {
                           strcpy(S,"");
                           WSEdit->setText(S);
                         }
                         KW->setFocus();
                         break;
   }
}

void EditDlg::keyPressEvent ( QKeyEvent * kev) {
   //debug("keypress %d",kev->ascii());
   if (kev->ascii()==13) {
      if (DF->DataArr[ DF->ZA[Item] ]->Type==TYP_WIND) {
         if (KW->hasFocus())
            WSEdit->setFocus();
         else {
            if (StoreData()) {
               NextBtnClick();
               //Chart->UpdateTag(Tag);
            }
         }
      } else {
         if (StoreData()) {
            NextBtnClick();
            //Chart->UpdateTag(Tag);
         }
      }
   } else 
      kev->ignore();
}

int EditDlg::StoreData() {
// Daten berprfen und speichern
int Type, W;
//float T;
short int WS,WR;
QString QS;
float f;
bool ok;
ShortDataType *SD;
FloatDataType *FD;
LongDataType* LD;

   debug ("StoreData: Tag=%d,  Item=%d, Count=%d",Tag,Item,Count);

   Type=DF->DataArr[ DF->ZA[Item] ]->Type;
   switch (Type) {
      case TYP_LINE :    
      case TYP_LEVEL :    
      case TYP_PRESSURE: QS=LEdit->text();
                         if (QS.isEmpty()) {
                           DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                         } else
                         {
                            QS.replace(QRegExp(","), ".");
                            f = QS.toFloat(&ok);
                            if (ok) {
                               //if (Type==TYP_LEVEL)
                               //   T=(int)rint(f);
                               //else
                               //   T=(int)rint(f*10.0);
                               //if (Type==TYP_PRESSURE)
                               //   T-=10000;
                               FD=(FloatDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                               (*FD)[Tag]=f;
                               DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,TRUE);
                               Chart->update();
                            } else {
                               QApplication::beep();
                               DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                               return FALSE;
                            }
                         }
                         DF->ValidTestAus(DF->VDTA[Count][DF->ZA[Item]][0]);
                         break;

      case TYP_WEATHER : QS=WetterEdit->text();
                         if (QS.isEmpty()) {
                           DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                         } else
                         {
                           W=QS.toInt(&ok);
                           if (ok) {
                             SD=(ShortDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                             (*SD)[Tag]=W;
                             DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,TRUE);
                             Chart->update();
                           } else {
                             QApplication::beep();
                             DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                             return FALSE;
                           }
                         }
                         break;

      case TYP_WIND :    WS=0;
                         WR=-1;
                         QS=WSEdit->text();
                         if (QS.isEmpty()) {
                           DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                         } else {
                           QS.replace(QRegExp(","), ".");
                           WS=(int)rint(10.0*QS.toFloat(&ok));
                           if (ok) {
                             DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,TRUE);
                           } else {
                             WS=0;
                             DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][0],Tag,FALSE);
                             QApplication::beep();
                           }
                         }
                         int Vld=KW->getValid();
                         DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][1],Tag,TRUE);
                         switch (Vld) {
                           case KWR_VALID : WR=(int)rint(KW->getDirection()*10.0);
                                            break;
                           case KWR_NODIR : WR=-1;
                                            break;
                           case KWR_INVALID:WR=-1;
                                            DF->SetValid(&DF->VDTA[Count][DF->ZA[Item]][1],Tag,FALSE);
                                            break;
                         }
                         W= (WR&0x0000FFFF) + ((WS&0x0000FFFF) << 16);
                         LD=(LongDataType*)(DF->DPTR[Count][ DF->ZA[Item] ]);
                         (*LD)[Tag]=W;
                         debug("W=%X",W);
                         debug("WR=%d",WR);
   debug("WR=%d  WS=%d",W&0x0000FFFF, (W>>16)&0x0000FFFF);
                         Chart->update();
                         break;
   }
   
   return TRUE;
}

void EditDlg::KWRValueChange(float f) {
   WindRichtungLab->setText(KW->directionToText(f));
}

void EditDlg::WetterEditChange(const char* Text) {
int i=0;
bool err=TRUE;
QString S = Text;

//debug("WetterEditChange");
   if (S.length()>0)
      i=S.toInt(&err);

   if ((err==TRUE) && (i>=0) && (i<=255)) {
      if (WetterIcon[i] == NULL) {
         WetterIcon[i] = new QPixmap(CalcWetterImage(i));
      }
      WetterBtn->setPixmap(*(WetterIcon[i]));
   } else {
      QApplication::beep();
   }
}

void EditDlg::WetterBtnClick() {
int W;
char S[10];

  sscanf(WetterEdit->text(),"%d",&W);
//debug("W=%d",W);

WeatherDlg WDLG(W, this, i18n("Select Weather"));

   if (WDLG.exec()) {
      W=WDLG.W;
      if (WetterIcon[W] == NULL) {
         WetterIcon[W] = new QPixmap(CalcWetterImage(W));
      }
      WetterBtn->setPixmap(*(WetterIcon[W]));
      sprintf(S,"%d",W);
      WetterEdit->setText(S);
   }
}

EditDlg::~EditDlg(void) {
   debug("~EditDlg");
   edlg=NULL;
}
