/***************************************************************************
                          toplevel.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    

#include "toplevel.h"
#include "qmessagebox.h"
#include "kiconloader.h"
#include "dlgconvert.h"
#include "dlgoptions.h"
#include "dlgdata.h"
#include "dlgpredefined.h"
#include "dlgimport.h"

extern DataDlg* ddlg;

#define EDITNEW  1
#define EDITMODIFY 2
#define P1 3
#define P2 4
#define P3 5
#define P4 6
#define P5 7
#define P6 8

TopLevel::TopLevel(const char *name=0)
  : KTopLevelWidget(name)
{
//debug("toplevel.create");
   Chart = new TChart(this);
   setupMenuBar();
   setupStatusBar();
   setupToolBar();
   setView(Chart);
   SetButtons();
   
}

TopLevel::~TopLevel() {
debug("Toplevel.delete");
   if (Chart->FileActive)
      Chart->CloseFile();
}

void TopLevel::setupMenuBar()
{
  menubar = new KMenuBar(this);

  fileMenu = new QPopupMenu();
  QPopupMenu *newMenu = new QPopupMenu();
  editMenu = new QPopupMenu();
  DisplayMenu = new QPopupMenu();
  helpMenu = new QPopupMenu();

  newMenu->insertItem(i18n("&Predefined"), this, SLOT(FileNewPredef()), CTRL+Key_N);
  newMenu->insertItem(i18n("&Customize"), this, SLOT(FileNew()), CTRL+Key_U);

  fileMenu->insertItem(i18n("&New"), newMenu, CTRL+Key_N);
  fileMenu->insertItem(i18n("Con&vert"), this, SLOT(FileConvert()),ALT+Key_V);
  fileMenu->insertItem(i18n("&Open"), this, SLOT(FileOpen()),CTRL+Key_O);
  fileMenu->insertItem(i18n("&Close"), this, SLOT(FileClose()));
  fileMenu->insertItem(i18n("&Toggle Datawindow"), this, SLOT(ShowDataWindow()));
  //fileMenu->insertItem(i18n("&Options"), this, SLOT(FileOptions()));
  //fileMenu->insertItem(i18n("&Data Import"), this, SLOT(FileDataImport()));
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&Exit"), kapp, SLOT(quit()), CTRL+Key_Q);

  newID=editMenu->insertItem(i18n("&New Month"), Chart, SLOT(EditNew()));
  modifyID=editMenu->insertItem(i18n("&Modify Month"), Chart, SLOT(EditModify()),CTRL+Key_M);
  editMenu->setItemEnabled(newID, FALSE);
  editMenu->setItemEnabled(modifyID, FALSE);
  
  DisplayMenu->insertItem(i18n("&Grid"), Chart, SLOT(GridSettings()), Key_G+ALT);

  helpMenu->insertItem(i18n("&Contents"), kapp, SLOT(appHelpActivated()), Key_F1);
  helpMenu->insertSeparator();
  helpMenu->insertItem(i18n("&About"), this, SLOT(aboutApp()));
  helpMenu->insertItem(i18n("About &KDE"), kapp, SLOT(aboutKDE()));

  menubar->insertItem(i18n("&File"), fileMenu);
  menubar->insertItem(i18n("&Edit"), editMenu);
  menubar->insertItem(i18n("&Display"), DisplayMenu);
  menubar->insertSeparator(-1);
  menubar->insertItem(i18n("&Help"), helpMenu);

  setMenu(menubar);
}

void TopLevel::setupToolBar()
{
  KIconLoader iconLoader;
  toolbar = new KToolBar(this);

  addToolBar(toolbar);

#define I(f,i,o,s,h) toolbar->insertButton( iconLoader.loadIcon(f),\
	 i, SIGNAL(clicked()), o, SLOT(s()), TRUE, h);

  I("filenew.xpm",  0,    this, FileNew, i18n("New"));
  I("fileopen.xpm", 0,    this, FileOpen, i18n("Open"));
  toolbar->insertSeparator();
  I("kt_new.xpm",   EDITNEW, Chart, EditNew, i18n("New Month"));
  I("kt_edit.xpm",  EDITMODIFY, Chart, EditModify, i18n("Edit Month"));
  toolbar->insertSeparator();
  I("pfeil_lf.xpm", P1,   Chart, MoveFirst, i18n("First"));
  I("pfeil_2l.xpm", P2,   Chart, MovePrevF, i18n("Fast Prev"));
  I("pfeil_l.xpm",  P3,   Chart, MovePrev,  i18n("Prev"));
  I("pfeil_r.xpm",  P4,   Chart, MoveNext,  i18n("Next"));
  I("pfeil_2r.xpm", P5,   Chart, MoveNextF, i18n("Fast Next"));
  I("pfeil_rf.xpm", P6,   Chart, MoveLast,  i18n("Last"));

  toolbar->insertSeparator();
  I("help.xpm",     0,    kapp,  appHelpActivated,  i18n("Help"));
#undef I
}

void TopLevel::setupStatusBar()
{
   statusbar = new KStatusBar(this);
   statusbar->insertItem("XXXXXXXXX",ST_MONAT);
   statusbar->insertItem("XXXX",ST_JAHR);
   statusbar->insertItem("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",ST_FILE);
   statusbar->changeItem("",ST_FILE);
   statusbar->changeItem("",ST_MONAT);
   statusbar->changeItem("",ST_JAHR);
   setStatusBar(statusbar);
}


void TopLevel::aboutApp()
{
  QMessageBox::about(this, i18n("About kweather"), i18n("kweather 0.3 build 30.8.2k by Juergen Hochwald"));
}

void TopLevel::SetButtons(void) {
// Abhngig von dem aktuellen Programmstand (Datei offen, Posi in der Datei)
// werden die Toolbatbuttond entsprechend freigegeben oder gesperrt.
int boo;
//debug("setbuttons");
   toolbar->setItemEnabled(EDITNEW, Chart->FileActive);
   toolbar->setItemEnabled(EDITMODIFY, Chart->FileActive);
   if (Chart->FileActive) {
      boo = Chart->FPos();
      toolbar->setItemEnabled(P1, boo);
      toolbar->setItemEnabled(P2, boo);
      toolbar->setItemEnabled(P3, boo);
      boo = (Chart->FPos() != (Chart->FSize()-1));
      toolbar->setItemEnabled(P4, boo);
      toolbar->setItemEnabled(P5, boo);
      toolbar->setItemEnabled(P6, boo);
   } else {
      toolbar->setItemEnabled(P1, FALSE);
      toolbar->setItemEnabled(P2, FALSE);
      toolbar->setItemEnabled(P3, FALSE);
      toolbar->setItemEnabled(P4, FALSE);
      toolbar->setItemEnabled(P5, FALSE);
      toolbar->setItemEnabled(P6, FALSE);
   }
}

void TopLevel::FileNewPredef() {
   PredefinedDlg PD(Chart, i18n("Create new File from Template"));
   PD.exec();

   editMenu->setItemEnabled(newID, Chart->FileActive);
   editMenu->setItemEnabled(modifyID, Chart->FileActive);
   SetButtons();
   statusbar->changeItem(Chart->GetFileName(), ST_FILE);
   //debug("fpos=%d   fsize=%d",Chart->FPos(),Chart->FSize());
}

void TopLevel::FileNew() {
   Chart->NewFile();
   editMenu->setItemEnabled(newID, Chart->FileActive);
   editMenu->setItemEnabled(modifyID, Chart->FileActive);
   SetButtons();
   statusbar->changeItem(Chart->GetFileName(), ST_FILE);
   //debug("fpos=%d   fsize=%d",Chart->FPos(),Chart->FSize());
}

void TopLevel::FileOpen() {
   Chart->OpenFile();
   if (Chart->FileActive) {
      editMenu->setItemEnabled(newID, Chart->FileActive);
      editMenu->setItemEnabled(modifyID, Chart->FileActive);
      SetButtons();
      statusbar->changeItem(Chart->GetFileName(), ST_FILE);
      //debug("fpos=%d   fsize=%d",Chart->FPos(),Chart->FSize());
      Chart->update();
   }
}

void TopLevel::FileClose() {
   Chart->CloseFile();
   editMenu->setItemEnabled(newID, Chart->FileActive);
   editMenu->setItemEnabled(modifyID, Chart->FileActive);
   SetButtons();
   statusbar->changeItem("", ST_FILE);
   statusbar->changeItem("", ST_JAHR);
   statusbar->changeItem("", ST_MONAT);
}

void TopLevel::keyPressEvent(QKeyEvent * kev) {
   //debug("Taste");
   switch (kev->key()) {
      case Key_Left : Chart->PrevDay();break;
      case Key_Right: Chart->NextDay();break;
      case Key_Next : if (kev->state() & ControlButton)
                         Chart->MoveNextF();
                      else
                         Chart->MoveNext();
                      break;
      case Key_Prior : if (kev->state() & ControlButton)
                         Chart->MovePrevF();
                      else
                         Chart->MovePrev();
                      break;
      case Key_Home : Chart->MoveFirst();
                      break;
      case Key_End :  Chart->MoveLast();
                      break;
   }
}


void TopLevel::FileConvert() {
ConvertDlg CDLG; //(this, "Convert");

   debug("ret=%d",CDLG.exec());
   
/*   EditDlg ED(this, "Enter Temperatures");

   //debug("editmodify");
   ED.exec();
*/
}

void TopLevel::FileOptions() {
OptionsDlg ODLG;

   debug("ret=%d",ODLG.exec());
}

void TopLevel::FileDataImport() {
ImportDlg IDLG;

   debug("ret=%d",IDLG.exec());
}

void TopLevel::ShowDataWindow() {
   if (ddlg!=NULL) {
      if (ddlg->isVisible())
         ddlg->hide();
      else
         ddlg->show();
   }
}

