/***************************************************************************
                          kreglo.cpp  -  description                              
                             -------------------                                         
   begin                : Thu Jul  1 16:24:56 MEST 1999
                                           
   copyright            : (C) 1999 by [CRY0]
   email                : cryo@tronet.de
 ***************************************************************************
 kreglo was the basis of this code. it is a quick and dirty hack to get a
 screen lens.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                      2                                  *
 ***************************************************************************/

#include "lens.h"

extern int window_size ;
extern int zoom_factor ;

KReglo::KReglo( QWidget*parent, const char* name ):QWidget(parent,name,WStyle_Customize | WStyle_Title | WStyle_DialogBorder )
   {		
   palette = QApplication::palette();
   setPalette(QPalette(QColor(180,180,0))) ;

   MainPainter      = new QPainter();
   MagnifierPainter = new QPainter();

   bIsDragging     = false;	
   bIsMovingWindow = false;
   resize(window_size,window_size) ;
   magnifierPixmap.resize(window_size,window_size) ;
   gCursor = new QCursor();
   setMouseTracking(true);
   timer = new QTimer(this);
   connect(timer,SIGNAL(timeout()),this,SLOT(refreshMouseCoordinates())) ;
   timer->start(200,false) ;
   }

KReglo::~KReglo()
   {
   setMouseTracking(false);	
   delete timer;
   delete gCursor;
   delete MainPainter;	
   delete MagnifierPainter;
   }

void KReglo::Quit()
   {
   exit(0);
   }

void KReglo::Preferences()
   {
   }

void KReglo::refreshMouseCoordinates()
   {
   int static old_x = 0 ;
   int static old_y = 0 ;

   if ( !bIsDragging )
      {
      globalMousePoint = gCursor->pos() ;
      if ( globalMousePoint.x() == old_x && globalMousePoint.y() == old_y ) return;
      QImage tmpImg;
      QWMatrix m;
      QPixmap dest;
      magnifierPixmap = QPixmap::grabWindow( QApplication::desktop()->winId(),
    	                        globalMousePoint.x()-((window_size/2)/zoom_factor), 		
		                        globalMousePoint.y()-((window_size/2)/zoom_factor),         	
                              window_size/zoom_factor,                 	
                              window_size/zoom_factor );	
      m.scale((double)zoom_factor,(double)zoom_factor) ;
      dest = magnifierPixmap.xForm(m) ;
      MagnifierPainter->begin(this) ;	
      MagnifierPainter->drawPixmap(0,0,dest,0,0,-1,-1) ;
      MagnifierPainter->end() ;
   	const QColor brushColor( 0, 0, 0 );		
      MainPainter->begin(this) ;	
      MainPainter->setBrush(brushColor) ;
      MainPainter->setPen(brushColor) ;
      MainPainter->setWindow(0,0,window_size,window_size) ;
      MainPainter->drawLine(window_size-window_size/3,window_size/3,window_size/3,window_size-window_size/3) ;
      MainPainter->drawLine(window_size/3,window_size/3,window_size-window_size/3,window_size-window_size/3);
      MainPainter->end();
      old_x = globalMousePoint.x() ;
      old_y = globalMousePoint.y() ;
      }
   }

void KReglo::paintEvent ( QPaintEvent *event )
   {		
   }

void KReglo::mouseReleaseEvent( QMouseEvent *e )
   {
   bIsDragging = false;
   raise();
   }

void KReglo::mousePressEvent( QMouseEvent *e )
   {
   bIsDragging = true;
   localMousePoint = mapFromGlobal( gCursor->pos() );
   setActiveWindow();
   }

void KReglo::mouseMoveEvent( QMouseEvent *e )
   {	
   if ( bIsDragging ) move(e->globalX()-localMousePoint.x(),e->globalY()-localMousePoint.y()) ;
   }

void KReglo::mouseDoubleClickEvent( QMouseEvent * e )
   {
   }







































