/***************************************************************************
                          publisherbase.h  -  description                              
                             -------------------                                         
    begin                : Mon Oct 4 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PUBLISHERBASE_H
#define PUBLISHERBASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <table.h>

/**
  *@author Jan Mueller
  */

class PublisherBase : public Table  {
 private:
  PublisherBase(const PublisherBase&);
	PublisherBase& operator=(const PublisherBase&);	


 	void initNew();
 	void initWhere(const char *where);
 public:
  /** Creates new note.
   */
  PublisherBase(Sql *conn);
  PublisherBase(const char *dbname);

  /** Reads row with the SQL-WHERE clause "where". "where" must not return more than one record.
   */
  PublisherBase(const char *where, Sql *conn);
  PublisherBase(const char *where, const char *dbname);

  /** Updates row, if data has changed and not readonly-mode.
   */
  virtual ~PublisherBase();

  const char *getName();
  const char *getCity();
	const char *getSerie();
	const char *getModified();
	const char *getCreated();

  void setName(const char *s);
  void setCity(const char *t);
	void setSerie(const char *t);

  PublTitle *getPubls();

  virtual const char *getWhereClause() { return _where; }

 private:
	KaspaRec *invalid();
  KaspaRec *read(const char *where);
  void write(const char *where, bool block=false);
  void del(const Oid o);
  PublisherRec *publisher();
  Str _where;
};

#endif