/***************************************************************************
                          publication.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: publication.cpp
	Last generated: Fri Sep 24 20:59:21 1999

 *********************************************************************/


#define Inherited PublicationData

#include <kmessagebox.h>
#include <kiconloader.h>
#include <kapp.h>
#include <qstring.h>
#include <qwhatsthis.h>

#include "publication.h"
#include "publbase.h"
#include "kaspawidget.h"
#include "resource.h"
#include "selectiondlg.h"
#include "klocale.h"

#define Inherited PublicationData

CommandSetup publcs[] = {	{ID_PUBL_DELREC,  			RW},
													{ID_PUBL_FLUSH,  				RW},
													{ID_PUBL_RESET, 				RW+RO+INV},
													{ID_PUBL_INSLINK, 			RW+RO},
													{ID_PUBL_REMLINK, 			RW+RO},
													{ID_PUBL_NEWLINK,				RW+RO},

													{ID_PUBL_SHOWBIBLIO,		RW+RO},
													{ID_PUBL_SHOWLINKS, 		RW+RO},
													{ID_PUBL_REMPART, 			RW+RO},
													{ID_PUBL_NEWPART,				RW+RO},

													{ID_PUBL_SHOWPUBLISHER,	RW+RO},
													{ID_PUBL_INSPUBLISHER, 	RW+RO},
													{ID_PUBL_NEWPUBLISHER, 	RW+RO},

													{ID_PUBL_NEWAUTHOR, 		RW+RO},
													{ID_PUBL_INSAUTHOR,			RW+RO},
													{ID_PUBL_REMAUTHOR,			RW+RO},	};


// PublicationBase-Constructor reads row matching WHERE-Clause.
Publication::Publication(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name)
{
	setTabOrder(title, year);
	setTabOrder(year, publisher);
	setTabOrder(publisher, entrytype);
	setTabOrder(entrytype, memo);

	
	
	QWhatsThis::add(title, 			i18n("The title might be the title of a\nbook, an article or a journal."));
	QWhatsThis::add(memo , 			i18n("This textarea takes your annotations about the publication."));
	QWhatsThis::add(entrytype,	i18n("The type of the publication.\nThis corresponds with the bibtex entry type."));
	QWhatsThis::add(publisher,	i18n("This field shows the publisher of the publication " \
																	 "or - if the publication is an article -  the journal. " \
																	 "You can insert, create and show publishers/journals with " \
																	 "the buttons of the toolbar"));
	QWhatsThis::add(links,			i18n("This box shows the links to the notes connected to a publication. " \
																	 "You may open the link in the same window by double-clicking the item " \
																	 "or in an new window via the context menu. You can open the context menu " \
																	 "by clicking the right mouse button. You may insert, create and delete " \
																	 "notes with the buttons of the toolbar."));
	QWhatsThis::add(authors,		i18n("This box shows the authors of a publication." \
																	 "You may open an author in the same window by double-clicking the item " \
																	 "or in an new window via the context menu. You can open the context menu " \
																	 "by clicking the right mouse button. You may insert, create and delete " \
																	 "authors with the buttons of the toolbar."));
	QWhatsThis::add(parts,			i18n("This box shows the parts of a publication. Parts are the chapters of a book " \
																	 "or the articles of a journal. " \
																	 "You may open a part in the same window by double-clicking the item " \
																	 "or in a new window via the context menu. You can open the context menu " \
																	 "by clicking the right mouse button. You may insert, create and delete " \
																	 "parts with the buttons of the toolbar."));
	QWhatsThis::add(year,				i18n("This field indicates when the publication was published."));	

	entrytype->insertItem("Book", 						BT_BOOK);
	entrytype->insertItem("Booklet",					BT_BOOKLET);
	entrytype->insertItem("Journal",					BT_JOURNAL);
	entrytype->insertItem("Manual", 					BT_MANUAL);
	entrytype->insertItem("Masterthesis", 		BT_MASTERTHESIS);
	entrytype->insertItem("Misc",  						BT_MISC);
	entrytype->insertItem("Proceeding",				BT_PROCEEDING);
	entrytype->insertItem("Technical Report", BT_TECHREPORT);
	entrytype->insertItem("Unpublished", 			BT_UNPUBLISHED);
	entrytype->insertItem("Phd Thesis", 			BT_PHDTHESIS);
	entrytype->insertItem("In Book", 					BT_INBOOK);
	entrytype->insertItem("In Collection", 		BT_INCOLLECTION);
	entrytype->insertItem("In Proceeding", 		BT_INPROCEEDING);
	entrytype->insertItem("Article",					BT_ARTICLE);

	debug("Publication::Publication(QString, QWidget, char*): url=%s", (const char *) url);
	if(url.command()=="new")
	  publ = new PublBase(conn);
	else
	  publ = new PublBase(url.where(), conn);
  ASSERT(publ);
	publ->setCallBack(&idle);
	QString s("kaspa://publication#where oid="); s+=QString().setNum(publ->id());
	_url=s;

  connect(links,   SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));
  connect(authors, SIGNAL(open(Oid, bool)), this, SLOT(requestAuthor(Oid, bool)));
  connect(parts,   SIGNAL(open(Oid, bool)), this, SLOT(requestPart(Oid, bool)));
  connect(entrytype,   SIGNAL(activated(const QString&)), this, SLOT(entrytype_changed(const QString&)));
	links->setTitle(i18n("Links"));
	parts->setTitle(i18n("Chapters"));
  int et=publ->getEntryType();
	if(et==BT_PROCEEDING || et==BT_INCOLLECTION || et==BT_INPROCEEDING)
		authors->setTitle(i18n("Editor"));
	else
		authors->setTitle(i18n("Author"));
		
		
	if(et==BT_ARTICLE)
		published_label->setText("Journal");
	else
		published_label->setText("Publisher");
}

Publication::~Publication()
{
	debug("Publication::~Publication()");
	delete publ;
}

bool Publication::isValid() {
	try {
	  return publ->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void Publication::reread() {
	setWorkingGUI();
	try {
	  publ->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
  setFields();
}

void Publication::setFields() {
  if(isValid()) {
		try  {
			setWorkingGUI();
	  	title->setText(publ->getTitle());
		  memo->setText(publ->getMemo());
	  	year->setText(publ->getYear());
			created->setText(QString("created: ")+publ->getCreated());
			modified->setText(QString("modified: ")+publ->getModified());
		  entrytype->setCurrentItem(publ->getEntryType());

			if(entrytype->currentItem()==BT_ARTICLE) {
		  	JournalName *rec=publ->getJournal();
  		  if(rec) {
	  	  	publisher->setText(rec->getTitle());
		  	  delete rec;
			  }
			}
	  	else {
		  	PublisherName *rec=publ->getPublisher();
			  if(rec) {
			  	publisher->setText(rec->getTitle());
				  delete rec;
				}
			}

		  links->set(publ->getLinks());
  		authors->set(publ->getPublAuthors());
		  parts->set(publ->getPublParts());
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}

void Publication::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Publication::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	  if(strcmp(title->text(), publ->getTitle()))
      	  publ->setTitle(title->text());
	      if(strcmp(memo->text(), publ->getMemo()))
  	      publ->setMemo(memo->text());
    	  if(strcmp(year->text(), publ->getYear()))
      	  publ->setYear(year->text());
	      if(entrytype->currentItem()!= publ->getEntryType())
  	      publ->setEntryType(entrytype->currentItem());
    	  publ->flush(block);
	  }
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Publication::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(publcs)/sizeof(CommandSetup); i++)
		emit enableCommand(publcs[i].command, ((publcs[i].setup&INV)==INV));
}	

void Publication::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(publcs)/sizeof(CommandSetup); i++)
		emit enableCommand(publcs[i].command, ((publcs[i].setup&RW)==RW));
}

void Publication::setWorkingGUI() {
	if(isReadOnly() || !isValid())
		lockGUI();
	else
		unlockGUI();
	Inherited::setWorkingGUI();
  links->setEnabled(FALSE);
  authors->setEnabled(FALSE);
  parts->setEnabled(FALSE);
	for(unsigned int i=0; i<sizeof(publcs)/sizeof(CommandSetup); i++)
		emit enableCommand(publcs[i].command, ((publcs[i].setup&WORK)==WORK));
}

void Publication::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	title->setEnabled(FALSE);
	memo->setEnabled(FALSE);
	year->setEnabled(FALSE);
	publisher->setEnabled(FALSE);
  entrytype->setEnabled(FALSE);
  links->setEnabled(TRUE);
  authors->setEnabled(TRUE);
  parts->setEnabled(TRUE);
	for(unsigned int i=0; i<sizeof(publcs)/sizeof(CommandSetup); i++)
		emit enableCommand(publcs[i].command, ((publcs[i].setup&RO)==RO));
}


void Publication::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()&&deleteDlg()) {
			setWorkingGUI();
	  	publ->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Publication::closeRequest() {
//	setWorkingGUI();
 	save(true);
	setupGUI();
  return TRUE;
}

void Publication::newAuthor() {
	try {
		setWorkingGUI();
		Oid o=publ->createAuthor();
		save();
		requestAuthor(o, false);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
		setupGUI();
}

void Publication::insAuthor() {
	try {
		SelectionDlg dlg(publ->getAuthors(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			publ->insertAuthor(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Publication::remAuthor() {
	try {
		Oid o=authors->getCurrentOid();
		if(o==InvalidOid) return;
			setWorkingGUI();
			publ->removeAuthor(o);
			save();
			setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Publication::showBiblio() {
	try {
		save(true);
		debug("Publication::showBiblio() - url=%s", url());
		QString s("kaspa://bibliography#where oid=");
		s+=QString().setNum(publ->id());
		requestURL(s, false);
		setupGUI();
  } catch(KaspaErr& err) {
		handleWarning(err);
  }
}

void Publication::newPart() {
	try {
		setWorkingGUI();
		save();
		Oid o=publ->createPart();
		requestPart(o);
		setupGUI();
  } catch(KaspaErr& err) {
		handleWarning(err);
  }
}

void Publication::remPart() {
	try {
		if(!deleteDlg()) return;
		Oid o=parts->getCurrentOid();
		if(o==InvalidOid) return;
		Str s="where part.oid=";
		oid2str(o, &s);
		setWorkingGUI();
		publ->deletePart(s);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Publication::newLink() {
	try {
		setWorkingGUI();
		Oid o=publ->createNote();
		requestNote(o);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
		setupGUI();
}
	
void Publication::insLink() {
	try {
		SelectionDlg dlg(publ->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			publ->insertLink(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Publication::remLink() {
	try {
		Oid o=links->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		publ->removeLink(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void Publication::showLinks() {
	try {
		save(true);
		QString s("kaspa://noteoverview#where publicationno="); s+=QString().setNum(publ->id());
		requestURL(s, false, publ->getTitle());
		setupGUI();
  } catch(KaspaErr& err) {
		handleWarning(err);
  }
}

KToolBar *Publication::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("showbiblio.xpm"), ID_PUBL_SHOWBIBLIO, SIGNAL(clicked()),
				this, SLOT(showBiblio()), true, i18n("Show Bibligraphy") );
  toolbar->insertButton(BarIcon("showpublisher.xpm"), ID_PUBL_SHOWPUBLISHER, SIGNAL(clicked()),
				this, SLOT(showPublisherOrJournal()), true, i18n("Show Publisher/Journal") );
  toolbar->insertButton(BarIcon("showlinks.xpm"), ID_PUBL_SHOWLINKS, SIGNAL(clicked()),
				this, SLOT(showLinks()), true, i18n("Show Links") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newauthor.xpm"), ID_PUBL_NEWAUTHOR, SIGNAL(clicked()),
				this, SLOT(newAuthor()), true, i18n("New Author") );
  toolbar->insertButton(BarIcon("insauthor.xpm"), ID_PUBL_INSAUTHOR, SIGNAL(clicked()),
				this, SLOT(insAuthor()), true, i18n("Insert Author") );
  toolbar->insertButton(BarIcon("delauthor.xpm"), ID_PUBL_REMAUTHOR, SIGNAL(clicked()),
				this, SLOT(remAuthor()), true, i18n("Delete Author") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newnote.xpm"), ID_PUBL_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.xpm"), ID_PUBL_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.xpm"), ID_PUBL_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newpublisher.xpm"), ID_PUBL_NEWPUBLISHER, SIGNAL(clicked()),
				this, SLOT(newPublisherOrJournal()), true, i18n("New Publisher/Journal") );
  toolbar->insertButton(BarIcon("inspublisher.xpm"), ID_PUBL_INSPUBLISHER, SIGNAL(clicked()),
				this, SLOT(insPublisherOrJournal()), true, i18n("Insert Publisher/Journal") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newpart.xpm"), ID_PUBL_NEWPART, SIGNAL(clicked()),
				this, SLOT(newPart()), true, i18n("New Part") );
  toolbar->insertButton(BarIcon("delpart.xpm"), ID_PUBL_REMPART, SIGNAL(clicked()),
				this, SLOT(remPart()), true, i18n("Remove Part") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filedel.xpm"), ID_PUBL_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_PUBL_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.xpm"), ID_PUBL_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}

void Publication::insPublisherOrJournal() {
	try {
		SelectionDlg *dlg;
		if(entrytype->currentItem()==BT_ARTICLE)
			dlg=new SelectionDlg(publ->getJournals(), this);
		else
			dlg=new SelectionDlg(publ->getPublishers(), this);
		if(dlg->exec()) {
			Oid o=dlg->getOid();
			if(o==InvalidOid) return;
			publ->setPublisherOrJournal(o);
			save();
			setFields();			
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Publication::newPublisherOrJournal() {
	try {
		setWorkingGUI();
		Oid o;
		if(entrytype->currentItem()==BT_ARTICLE)
  		o=publ->createJournal();
  	else
  		o=publ->createPublisher();
  		
		publ->setPublisherOrJournal(o);
		save();
		
		if(entrytype->currentItem()==BT_ARTICLE)
  		requestJournal(o);
  	else
  		requestPublisher(o);
  		
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Publication::showPublisherOrJournal() {
	try {
		save(true);
		if(entrytype->currentItem()==BT_ARTICLE) {
			JournalName *p=publ->getJournal();
			if(p) requestJournal(p->getOid());
			else	KMessageBox::information(this, i18n("No journal defined!"), i18n("Information"));
			delete p;
		}
		else {	
			PublisherName *p=publ->getPublisher();
		  if(p) requestPublisher(p->getOid());
		  else	KMessageBox::information(this, i18n("No publisher defined!"), i18n("Information"));
		  delete p;
		}

	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Publication::entrytype_changed(const QString& s) {
  if(s=="Article" || s=="Journal")
  	published_label->setText("Journal");
  else
  	published_label->setText("Publisher");
}
