/***************************************************************************
                          cmapundoelement.cpp
                      -------------------
    description          :
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmapundoelement.h"

CMapUndoElement::CMapUndoElement()
{
  origin_ = NULL;
  dir_ = (direction)0;
  flags_ = 0;
}

CMapUndoElement::~CMapUndoElement()
{
}

CMapUndoElement::CMapUndoElement(CMapRoom* origin, direction dir, uint flags)
{
  origin_ = origin;
  dir_ = dir;
  flags_ = flags;
}
	
void CMapUndoElement::setRoom(CMapRoom* room)
{
  origin_ = room;
}

void CMapUndoElement::setDirection(direction dir)
{
  dir_ = dir;
}

void CMapUndoElement::setAllFlags(uint flags)
{
  flags_ = flags;
}

CMapRoom* CMapUndoElement::getRoom()
{
  return origin_;
}

direction CMapUndoElement::getDirection()
{
  return dir_;
}

uint CMapUndoElement::getAllFlags()
{
  return flags_;
}

	
void CMapUndoElement::setFlag(uint mask)
{
  flags_ = flags_ | mask;
}

void CMapUndoElement::clearFlag(uint mask)
{
  mask = mask & flags_; // be sure to change only flags that are set
  flags_ = flags_ ^ mask;
}

bool CMapUndoElement::isFlagSet(uint mask)
{
  return (flags_ & mask) != 0;
}

