/***************************************************************************
                          ctelnet.h
                       -------------------
    description          : Class for sending/receiving data via a telnet-connection
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef __CTELNET_H__
#define __CTELNET_H__

#include <qobject.h>

#include "mccpDecompress.h" /* mccp */

class QSocketNotifier;

/**
  * Class for sending and revceiving data via a telnet connection.
  *@author Stephan Uhlmann
  */

class CTelnet : public QObject
{
 Q_OBJECT

public:
	/** constructor */
	CTelnet();
	/** destructor */
	~CTelnet();
  
	/** connect to a given host to a given port */
	int connect(QString hostname, unsigned long port,unsigned int timeout);
	/** closes connection */
	void close();
	/** checks whether echo is on or off */
	bool isEchoOn();
	/** sets/unsets the echo, emits echoChanged() */
	void setEcho(bool b);
	/** gets the name of the host connected to */
	QString getHostName() const;
	/** gets the IP of the host connected to */
	QString getHostIP() const;
	/** gets the Port to which we are connected to */
	unsigned long getHostPort() const;
	/** true if connection is established, else false */
	bool isConnected() const;

public slots:
	/** receives data and stores it into an internal buffer. emits 
	  * filledBuffer(QString) where QString is the data without the 
	  * previous interpreted telnet-commands 
	  */
	int receiveData();
	/** sends data via the telnet-connection */
	int sendData(QString buf, int len) const;

signals:
	/** will be emitted when received data, QString is the data without telnet-commands */
	void filledBuffer(QString);
	/** emitted when echo was changed, can be done by the negotiation of the telnet-protocol */
	void changedEcho(bool);
	/** emitted when the connection was closed */
	void closedConnection();
 
private:
	QString hostName;
	unsigned long hostIP;
	unsigned long hostPort;
	mc_state *mccpState;  /* MCCP */

	int tsocket;
	QString buffer;
	QString oldBuffer;
	bool echo;
	QSocketNotifier* notifierRead;

	bool isInterpretAsCommand(unsigned char c) const;
	bool isCommand(unsigned char byte) const;
	bool isOption(unsigned char byte) const;
	QString convertCommand(unsigned char Command) const;
	QString convertOption(unsigned char Option) const;
	int processCommands();

};

#endif /* __CTELNET_H__ */
