/***************************************************************************
                          dlgpingprogress.cpp
                      -------------------
    description          :
    begin                : Sun Oct 8 2000
    copyright            : (C) 2000 by Kmud Developer team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgpingprogress.h"
#include <kapp.h>

DlgPingProgress::DlgPingProgress(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	
	connect(button, SIGNAL(clicked()), this, SLOT(slotButtonClicked()));
}

DlgPingProgress::~DlgPingProgress()
{
}

void DlgPingProgress::slotPingOutput(QString output)
{
  outputWindow->insertLine(output);
}

void DlgPingProgress::slotPingStatus(int status)
{
  switch (status)
  {
    case 0: // ping successful
      pingRunning = false;
      button->setText(i18n("OK"));
      break;

    case 1: // ping failed
      pingRunning = false;
      button->setText(i18n("OK"));
      break;

    default: // execution error, maybe wrong executable or parameter
      pingRunning = false;
      done(PING_ERROR);
      break;
  }
}

void DlgPingProgress::slotButtonClicked()
{
  if (pingRunning)
  {
    emit cancelPing();
    done(PING_CANCELED);
  }
  else
  {
    done(PING_OK);
  }
}
