/***************************************************************************
                          kbearwizard.cpp  -  description
                             -------------------
    begin                : Wed Jul 19 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearwizard.h"
//-----------------------------------------------
KBearWizard::KBearWizard(QWidget *parent, const char *name )
	: KWizard( parent, name, true )
{
	//setup the GUI
	setup();
}
//-----------------------------------------------
KBearWizard::~KBearWizard(){
	removePage( page3 );
}
//-----------------------------------------------
/** setup the GUI for the wizard */
void KBearWizard::setup(){
////////////////////////////////////////////////////////////////////
// Page 1
	page1 = new QWidget( this, "Page1" );

	QLabel* welcomeLogoBackLabel = new QLabel( page1, "WelcomeBackLabel");
	welcomeLogoBackLabel->setGeometry(10,10,530,80);
	QString pathString = KGlobal::dirs()->findResourceDir( "data","kbear/pics/kbear_welcome_logo.png" );
	welcomeLogoBackLabel->setPixmap(QPixmap(pathString + "kbear/pics/kbear_welcome_logo.png"));

	QTextView* welcomeTextView = new QTextView( page1, "WelcomeTextView" );	
	welcomeTextView->setGeometry(40,120,460,160);
	welcomeTextView->setText( i18n( "Here you can change the visible appearence of the different\n"
																"views as well as the main window.\n"
																"You can also personalize the sitemanager.\n"
																 "If there is something you wonder about, just hit the \"whats this button\"\n"
																 "in the upper right corner, and then move the mouse to the place\n"
																 "you wonder about and push the mouse button again,\n"
																 "a help message will then be displayed at the mouse position.\n"
																 "For more information push the help button in the lower right corner." ) );

////////////////////////////////////////////////////////////////////
// Page 2
	page2 = new ViewSettingsWidget( this, "Page2" );

////////////////////////////////////////////////////////////////////
// Page 3
	page3 = new MixedSettingsWidget( this, "Page3" );

////////////////////////////////////////////////////////////////////
// Page 4
	page4 = new KBearSiteManager( this, "Page4" );
	((KBearSiteManager*)page4)->setConnectEnabled( false );

////////////////////////////////////////////////////////////////////
// Add all pages
	addPage( page1, "" );
	addPage( page2, "" );
	addPage( page3, "" );
	addPage( page4, "" );
	setFinishEnabled ( page4, true );
	resize( 560,560);
}
//-----------------------------------------------
/**  */
void KBearWizard::help(){
}
//-----------------------------------------------
