/***************************************************************************
                          framedlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FRAMEDLG_H
#define FRAMEDLG_H

#include <qdialog.h>
#include "frameitem.h"

class QLineEdit;
class QButtonGroup;
class QCheckBox;
class KColorButton;
class KplDoc;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Frame settings dialog class. Provides a dialog for the
  * settings of frame and labels.
  * @author Werner Stille
  */
class FrameDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param it index of frame item.
   */
  FrameDlg(QWidget* parent, KplDoc* model, int it);
  /** Destructor. */
	~FrameDlg();
  /**
   * Copies settings to frame data structure.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);

protected:
  /**
   * Displays dialog to edit the contents of a QLineEdit widget.
   * @param ed pointer to widget.
   */
  void editText(QLineEdit* ed);
  KplDoc* m;
  int item, iex, iey;
  double fx, fy;
  FrameItem* pfd;
  FrameItem fd;
  KplDoubleEdit *ex0, *exl, *ey0, *eyl, *exMin, *exMax,
                *eyMin, *eyMax, *exTic, *eyTic;
  QLineEdit *eLetX, *eLetY, *eLetH;
  QButtonGroup* bg;
  KColorButton *colFrame, *colGrid;
  KplSpinBox *emTicx, *emTicy, *enDigx, *enDigy, *ex, *ey, *eRelSiz;
  QCheckBox *logX, *logY, *autoNorm;

protected slots:
  /** Updates dialog according to logarithmic axis option. */
  void slotLogToggled(bool state);
  /** Updates dialog according to autonormalization option. */
  void slotNormToggled(bool state);
  /** Displays dialog to edit the x axis label. */
  void slotEditLetX();
  /** Displays dialog to edit the y axis label. */
  void slotEditLetY();
  /** Displays dialog to edit the heading. */
  void slotEditLetH();
  /**
   * Performs automatic scaling of arrays and functions to be
   * plotted in this frame.
   */
  void slotAutoScale();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Applies settings without leaving the dialog. */
  void slotApply();
  /** Displays help for the frame settings dialog. */
  void slotHelp();
};

#endif
