/***************************************************************************
                          funcdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FUNCDLG_H
#define FUNCDLG_H

#include <qdialog.h>

class KplDoc;
class KColorButton;
class QLineEdit;
class QListBox;
class FunItem;
class ParFunItem;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Function settings dialog class. Provides a dialog for the settings
  * of an ordinary function.
  * @author Werner Stille
  */
class FuncDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param fd pointer to function data structure.
   */
  FuncDlg(QWidget* parent, KplDoc* model, FunItem* fd);
  /** Destructor. */
  ~FuncDlg();

protected:
  /**
   * Copies settings to temporary function data structure.
   * @return false for error.
   */
  bool getTemp();
  /**
   * Copies settings to function data structure.
   * @param accept true for leaving the dialog, false for applying.
   * @return false for error.
   */
  void getValues(bool accept);
  KplDoc* m;
  FunItem *fd, *fdt;
  QLineEdit *fileName, *func;
  KplDoubleEdit *exMin, *exMax, *exStep, *efx, *efy;
  KplSpinBox* symb;
  KColorButton* colData;

protected slots:
  /** Displays the dialog for selection of a library file to load. */
  void slotFile();
  /** Displays the dialog for selection of a function. */
  void slotFunc();
  /** Displays the dialog for selection of a parameter file to read. */
  void slotGetParameter();
  /** Displays the dialog for parameter editing. */
  void slotEditParameter();
  /** Displays the dialog for selection of a parameter file to save. */
  void slotSaveParameter();
  /** Saves function value table into a data file. */
  void slotExportValues();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Applies settings without leaving the dialog. */
  void slotApply();
  /** Displays help for the function settings dialog. */
  void slotHelp();
};

/**
  * Parametric function settings dialog class. Provides a dialog for the settings
  * of parametric functions.
  * @author Werner Stille
  */
class ParFuncDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param fd pointer to parametric function data structure.
   */
  ParFuncDlg(QWidget* parent, KplDoc* model, ParFunItem* fd);
  /** Destructor. */
  ~ParFuncDlg();

protected:
  /**
   * Copies settings to temporary parametric function data structure.
   * @return false for error.
   */
  bool getTemp();
  /**
   * Copies settings to parametric function data structure.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  ParFunItem *fd, *fdt;
  QLineEdit *fileNamex, *funcx, *fileNamey, *funcy;
  KplDoubleEdit *etMin, *etMax, *etStep, *efx, *efy;
  KplSpinBox* symb;
  KColorButton* colData;

protected slots:
  /** Displays the dialog for selection of a library file to load for the x axis. */
  void slotFilex();
  /** Displays the dialog for selection of a library file to load for the y axis. */
  void slotFiley();
  /** Displays the dialog for selection of a function for the x axis. */
  void slotFuncx();
  /** Displays the dialog for selection of a function for the y axis. */
  void slotFuncy();
  /** Displays the dialog for selection of a parameter file to read for the x axis function. */
  void slotGetParameterx();
  /** Displays the dialog for selection of a parameter file to read for the y axis function. */
  void slotGetParametery();
  /** Displays the dialog for parameter editing for the x axis function. */
  void slotEditParameterx();
  /** Displays the dialog for parameter editing for the y axis function. */
  void slotEditParametery();
  /** Displays the dialog for selection of a parameter file to save for the x axis function. */
  void slotSaveParameterx();
  /** Displays the dialog for selection of a parameter file to save for the y axis function. */
  void slotSaveParametery();
  /** Saves function value table into a data file. */
  void slotExportValues();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Applies settings without leaving the dialog. */
  void slotApply();
  /** Displays help for the parametric function settings dialog. */
  void slotHelp();
};

#endif
