//#include <kwm.h>
#include <kapp.h>
#include <qkeycode.h>
#include "stringres.h"

#include "Login.h"
#include <kglobal.h>
#include <kconfig.h>
#include <qpushbutton.h>

#define Inherited LoginData

CLogin::CLogin(QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    setCaption( CStringRes::get_string(45));
    setIcon(kapp->icon());

    KConfig * k = KGlobal::config();
    k->setGroup("last_login");
    QString user,host,port;
    user = k->readEntry("user");
    host = k->readEntry("host");
    port = k->readEntry("port");
    
    if (port.length() > 0) 
        PortEdit->setText(port);
    else
        PortEdit->setText("3306");
    if (host.length() > 0)
        HostEdit->setText(host);
    if (user.length() > 0)
        UserEdit->setText(user);
    HostEdit->setFocus();
}

CLogin::~CLogin()
{
}

void CLogin::focus_user()
{
    UserEdit->setFocus();
}
void CLogin::focus_password()
{
    PassEdit->setFocus();
}
void CLogin::focus_port()
{
    PortEdit->setFocus();
}
void CLogin::focus_ok()
{
    OkButton->setFocus();
}

void CLogin::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
        e->accept();
        OkButton->animateClick();
        return;
    }
    if (e->isAccepted())
        return;
    QDialog::keyPressEvent(e);
}
