#include "MainApp.h"
#include <qkeycode.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <qtstream.h>
#include <qmenudta.h>
#include <kpopupmenu.h>
#include <qlayout.h>
#include "stringres.h"
#include "MainWindow.h"
#include "kmysqladmin/setup/setupdlg.h"
#include "kmysqladmin/helpers/helpers.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/setup/settings.h"
#include <klocale.h>
#include <iostream>

#include "resource.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define Inherited KMainWindow

using namespace std;

CMainApp::CMainApp(const char* name,bool _first)
        :Inherited(0,name ),CSendMessage()
{
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);
    
    MainWidget = new CMainWindow( this, "MainWidget" );
    MainWidget->set_msg_ptr(this);

    connect(MainWidget,SIGNAL(connected(const char*)),this,SLOT(connected_to_server(const char*)));
    connect(MainWidget,SIGNAL(disconnected()),this,SLOT(disconnected_from_server()));
    setCentralWidget(MainWidget);

    initMenu();
    initToolbar();
    disconnected_from_server();
    setMinimumSize( 370, 190 );
    setMaximumSize( 32767, 32767 );
    KConfig * k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    if (w && h) {
        if ( (h-10) > 0)
            MainWidget->resize(w,h-10);
        resize(w,h);
    }
    if (_first) {
        if (kapp->isRestored()) {
            MainWidget->RestoreLastConnect();
        } else {
        }
    }
}

void CMainApp::initToolbar()
{
    toolBar()->insertButton(BarIcon("connect_creating"), ID_CONNECT, SIGNAL(clicked()),MainWidget,SLOT(connectSql()),
                            MainWidget->connected()==false,GET_TEXT(153));
    toolBar()->insertSeparator();
    toolBar()->insertButton(BarIcon("viewtab"),ID_SEARCH_TABLE,SIGNAL(clicked()),MainWidget,SLOT(browseTables()),
                            MainWidget->connected(),GET_TEXT(90));
    toolBar()->insertSeparator();
    toolBar()->insertButton(BarIcon("access_rights"),ID_ACCESS_RIGHTS,SIGNAL(clicked()),MainWidget,SLOT(accessControl()),
                            MainWidget->connected(),GET_TEXT(154));
    toolBar()->insertButton(BarIcon("status"),ID_STATUS,SIGNAL(clicked()),MainWidget,SLOT(dispStatus()),
                            MainWidget->connected(),GET_TEXT(155));
    toolBar()->insertButton(BarIcon("threads"),ID_THREADS,SIGNAL(clicked()),MainWidget,SLOT(view_threads()),
                            MainWidget->connected(),GET_TEXT(156));
    toolBar()->insertSeparator();

    toolBar()->insertButton(BarIcon("newdb"),ID_NEW_DB,SIGNAL(clicked()),MainWidget,SLOT(createDB()),
                            MainWidget->connected(),GET_TEXT(157));
    toolBar()->insertButton(BarIcon("newtab"),ID_NEW_TABLE,SIGNAL(clicked()),MainWidget,SLOT(createTable()),
                            MainWidget->connected(),GET_TEXT(3));
    toolBar()->insertButton(BarIcon("altertab"),ID_MODIFY_TABLE,SIGNAL(clicked()),MainWidget,SLOT(alterTable()),
                            MainWidget->connected(),GET_TEXT(114));
}

void CMainApp::initMenu()
{
    int id;
    MenuBar = menuBar();
    file = new KPopupMenu;
    
    id_map["connect"]=file->insertItem(SmallIcon("connect_creating"),GET_TEXT(153),MainWidget,SLOT(connectSql()),CTRL+Key_C);
    id_map["disconnect"]=file->insertItem(SmallIcon("connect_no"),i18n(CStringRes::get_string(47)),MainWidget,SLOT(disconnectSql()),CTRL+Key_D);
    id_map["last_connect"]=file->insertItem(SmallIcon("redo"),i18n(CStringRes::get_string(145)),MainWidget,SLOT(RestoreLastConnect()));

    QString text = CStringRes::get_string(48);
    file->insertItem(SmallIcon("eraser"),i18n(text),MainWidget,SLOT(clearOutput()));
    file->setCheckable(TRUE);
    id_map["logfile"] = file->insertItem(SmallIcon("filesaveas"),i18n(CStringRes::get_string(49)),this,SLOT(set_LogFileName()),CTRL+Key_S);
    file->insertSeparator();
    file->insertItem(SmallIcon("window_new"),i18n(CStringRes::get_string(122)),this,SLOT(new_window()),CTRL+Key_N);
    file->insertSeparator();
    file->insertItem(SmallIcon("fileclose"),i18n(CStringRes::get_string(123)),this,SLOT(windowClose()),CTRL+Key_W);
    file->insertItem(SmallIcon("exit"),GET_TEXT(149),this,SLOT(raus_hier()),CTRL+Key_Q);
    MenuBar->insertItem(i18n(CStringRes::get_string(109)),file);

    server_menu = new KPopupMenu;
    id = server_menu->insertItem(SmallIcon("rebuild"),i18n(CStringRes::get_string(52)),MainWidget,SLOT(flush_cache()));
    id = server_menu->insertItem(i18n(CStringRes::get_string(53)),MainWidget,SLOT(close_tables()));
    id = server_menu->insertItem(SmallIcon("filenew"),i18n(CStringRes::get_string(54)),MainWidget,SLOT(new_log()));
    server_menu->insertSeparator();
    id = server_menu->insertItem(SmallIcon("reload"),i18n(CStringRes::get_string(55)),MainWidget,SLOT(reload_grants()));
    QString e_str = "&";e_str+=i18n(CStringRes::get_string(56));
    id = server_menu->insertItem(SmallIcon("stop"),e_str,MainWidget,SLOT(shutdown()));
    server_menu->insertSeparator();
    id = server_menu->insertItem(SmallIcon("access_rights"),GET_TEXT(154),MainWidget,SLOT(accessControl()));
    id = server_menu->insertItem(SmallIcon("status"),GET_TEXT(155),MainWidget,SLOT(dispStatus()));
    id = server_menu->insertItem(SmallIcon("threads"),GET_TEXT(156),MainWidget,SLOT(view_threads()));
    server_menu->insertSeparator();
    id_map["edit"] = server_menu->insertItem(SmallIcon("edit"),GET_TEXT(150),MainWidget,SLOT(sql_Edit()),CTRL+Key_E);
    MenuBar->insertItem(i18n(CStringRes::get_string(161)),server_menu);
    
    db_menu = new KPopupMenu;
    id = db_menu->insertItem(SmallIcon("viewtab"),GET_TEXT(90),MainWidget,SLOT(browseTables()),CTRL+Key_B);
    db_menu->insertSeparator();
    id = db_menu->insertItem(SmallIcon("newdb"),GET_TEXT(157),MainWidget,SLOT(createDB()));
#if 0
    id = db_menu->insertItem(i18n(CStringRes::get_string(50)),MainWidget,SLOT(drop_db()));
#endif
    db_menu->insertSeparator();
    id = db_menu->insertItem(SmallIcon("newtab"),GET_TEXT(3),MainWidget,SLOT(createTable()));
    id = db_menu->insertItem(SmallIcon("altertab"),GET_TEXT(114),MainWidget,SLOT(alterTable()));
    id = db_menu->insertItem(SmallIcon("tab_duplicate"),i18n(CStringRes::get_string(110)),MainWidget,SLOT(rename_table()));
    id = db_menu->insertItem(SmallIcon("edittrash"),i18n(CStringRes::get_string(51)),MainWidget,SLOT(drop_table()));
    MenuBar->insertItem(i18n(CStringRes::get_string(57)),db_menu);

    setup_menu = new KPopupMenu;
    id = setup_menu->insertItem(SmallIcon("configure"),GET_TEXT(151),this,SLOT(layout_setup()));
    MenuBar->insertItem(i18n(CStringRes::get_string(146)),setup_menu);

    MenuBar->insertSeparator();

    KPopupMenu *help = helpMenu();
    MenuBar->insertItem(i18n(CStringRes::get_string(111)),help );
}

CMainApp::~CMainApp()
{
    filepointer.close();
}
  
void CMainApp::append_message(const std::string&message)
{
    if (message.size()==0)
        return;
    MainWidget->append_message(message);
    if (filepointer.good()) {
        filepointer << message << "\n";
        filepointer.flush();
    }
}

void CMainApp::set_LogFileName()
{
    QString s;
    if (logfile.size()==0) {
        s = KFileDialog::getOpenFileName(0,"*.log");
        if (!s.isEmpty()) {
            logfile = s.latin1();
            filepointer.open(logfile.c_str(),ios::out|ios::app|ios::ate);
            if (!filepointer.good())
                logfile = "";
        }
    } else {
        logfile = "";
        filepointer.flush();
        filepointer.close();
    }
    file->setItemChecked( id_map["logfile"],(logfile.empty()?0:1) );
}

void CMainApp::disconnected_from_server()
{
    unsigned int i;
    int j;

    file->setItemEnabled(id_map["connect"],true);
    file->setItemEnabled(id_map["last_connect"],true);
    file->setItemEnabled(id_map["disconnect"],false);

    for (i = 0; i <= db_menu->count();i++) {
        j = db_menu->idAt(i);
        if (j != -1) {
            db_menu->setItemEnabled(j,FALSE);
        }
    }
    for (i = 0; i <= server_menu->count();i++) {
        j = server_menu->idAt(i);
        if (j != -1) {
            server_menu->setItemEnabled(j,FALSE);
        }
    }
    toolBar()->setItemEnabled(ID_CONNECT,true);

    for (j = ID_ACCESS_RIGHTS;j <= ID_SEARCH_TABLE;++j) {
        toolBar()->setItemEnabled(j,false);
    }
    QString head = GET_TEXT(125);head+=" - ";head+=GET_TEXT(124);
    setCaption(head);
}

void CMainApp::connected_to_server(const char*msg)
{
    unsigned int i;
    int j;
    
    file->setItemEnabled(id_map["connect"],false);
    file->setItemEnabled(id_map["last_connect"],false);
    file->setItemEnabled(id_map["disconnect"],true);

    for (i = 0; i <= db_menu->count();i++) {
        j = db_menu->idAt(i);
        if (j != -1) {
            db_menu->setItemEnabled(j,TRUE);
        }
    }
    for (i = 0; i <= server_menu->count();i++) {
        j = server_menu->idAt(i);
        if (j != -1) {
            server_menu->setItemEnabled(j,TRUE);
        }
    }

    QString head = GET_TEXT(125);head+=" - ";
    if (msg) {
        head+=msg;
    } else {
        head+="connected";
    }
    toolBar()->setItemEnabled(ID_CONNECT,false);
    for (j = ID_ACCESS_RIGHTS;j <= ID_SEARCH_TABLE;++j) {
        toolBar()->setItemEnabled(j,true);
    }
    setCaption(head);
}

void CMainApp::new_window()
{
    CMainApp*dlg = new CMainApp;
    dlg->show();
}

void CMainApp::raus_hier()
{
    MainWidget->close();
    close();
}

void CMainApp::windowClose()
{
    MainWidget->close();
    close();
}

bool CMainApp::queryExit()
{
    return true;
}

bool CMainApp::queryClose()
{
    queryExit();
    KConfig*k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    w = width();
    h = height();
    QString s;
    s.setNum(w);
    k->writeEntry("width",s);
    s.setNum(h);
    k->writeEntry("height",s);
    return true;
}

void CMainApp::layout_setup()
{
    CSetupDlg layout_setup;
    if (layout_setup.exec()) {
        QFont fix_font = layout_setup.fixed_font();
        QFont nprop_font = layout_setup.nonprop_font();
        GlobalSettings.set_fixed_font(fix_font);
        GlobalSettings.set_nprop_font(nprop_font);
        GlobalSettings.StatusPolltime(layout_setup.StatusPolltime());
        GlobalSettings.ThreadPolltime(layout_setup.ThreadPolltime());
    }
}
