/* -*- c++ -*-
 *
 * mldonkeyappletgui.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef MLDONKEYAPPLETGUI_H
#define MLDONKEYAPPLETGUI_H

#include <qwidget.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QLabel;
class QPushButton;
class KIconLoader;

class MLDonkeyAppletGUI;

class MLDonkeyAppletGUILabel : public QObject
{
public:
    MLDonkeyAppletGUILabel(MLDonkeyAppletGUI * parent, const char * name, bool islabel);
    ~MLDonkeyAppletGUILabel();

    QLabel* label();

    void setEnabled();
    void setDisabled();

    void setText(const QString& = QString::null);
    void setTooltip(const QString& = QString::null);

private:
    QString text, tooltip;
    bool islabel;
    QLabel* m_label;
};

class MLDonkeyAppletGUI : public QWidget
{
    Q_OBJECT

public:
    MLDonkeyAppletGUI( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~MLDonkeyAppletGUI();

    void relayoutWidgets(int small);

    bool isMute();
    void mute(bool);

public slots:
    virtual void updateLayout();
    void updateLabels(const QString&, const QString&);
    void updateStatus(const QString&, const QString&);
    void updateTooltips(const QString&, const QString&);
    virtual void donkeyDisconnected();
    virtual void setLaunchState(bool state);

signals:
    void toggledLaunch(bool t);
    void toggledMute(bool t);

protected:
    KIconLoader icons;

    QHBoxLayout* lay;
    QHBoxLayout* horiz;
    QGridLayout* grid;
    int mysize;

    QPushButton* LaunchButton;
    QPushButton* MuteButton;

    MLDonkeyAppletGUILabel* FirstLabel;
    MLDonkeyAppletGUILabel* FirstStatus;
    MLDonkeyAppletGUILabel* SecondLabel;
    MLDonkeyAppletGUILabel* SecondStatus;

    void createLaunchButton();
    void createMuteButton();

protected slots:
    virtual void toggleLaunch(bool t);
    virtual void toggleMute(bool t);
};

#endif // MLDONKEYAPPLETGUI_H
