/* -*- c++ -*-
 *
 * debugpage.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_debugpage_h__
#define __kmldonkey_debugpage_h__

#include <qobject.h>
#include <qvbox.h>

#include "mldplugin.h"
#include "page.h"

class KMLDonkey;
class KTextBrowser;

class DebugPagePlugin : public KMLDonkeyPlugin
{
    Q_OBJECT
public:
    DebugPagePlugin(KMLDonkey* app, QWidget* parent = 0, const char* name = 0);

    QString pluginName();
    QString pluginTitle();
    QString pluginIcon();
    QString pluginDescription();

    KMLDonkeyPage* addPage(QWidget* parent);
};

class DebugPage : public QVBox, public KMLDonkeyPage
{
    Q_OBJECT
public:
    DebugPage(KMLDonkey* app, QWidget* parent = 0);

    virtual void applyPreferences(KMLDonkeyPreferences* = 0);
    virtual void clear();

public slots:
    void write(const DonkeyMessage* msg);
    void write(const QString& msg);

private:
    KTextBrowser* debugView;
    KMLDonkey* m_app;
};

#endif
