/***************************************************************************
                          kfmprojectlist.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFMPROJECTLIST_H
#define KFMPROJECTLIST_H

#include <qobject.h>
#include <qdom.h>
#include <qstring.h>
#include <qsortedlist.h>

class KFMProject;

/**Model class containing a list of projects
  *@author Jeffrey Yu
  */

class KFMProjectList : public QObject  {
	Q_OBJECT
public: 
	KFMProjectList();
	~KFMProjectList();

	///////////////////////////////////////////////	
	
	typedef QListIterator<KFMProject> Iterator;
	
	/** Retrieve an iterator over the projectList */
	Iterator iterator() const;
	
	/** Place a project into the projectList.
			@param project The project to add
		*/
	void addProject(KFMProject* project);
	
	/** Remove a project from the projectList.  The project is deleted.
			@param project The project to delete */
	void removeProject(KFMProject* project);
		
	/** Clear the projectList of all projects.  Projects are deleted. */
	void clear();
	
	///////////////////////////////////////////////
	
	/** Retrieve the position of a project in the projectList.
			@param project The project to locate
		*/
	int projectPosition(KFMProject* project) const;
	
	/** Retrieve the project at a position in the projectList.
			@param pos A position in the projectList
		*/
	KFMProject* projectAt(int pos) const;
	
	/** Retrieve the first project in the projectList. */
	KFMProject* firstProject() const;
	
	///////////////////////////////////////////////	
	
	/** Retrieve the position of the current project. */
	int currentPosition() const;
	
	/** Select the current project. */
	void currentProject(KFMProject* project);
	
	/** Retrieve the current project. */
	KFMProject* currentProject() const;
	
	///////////////////////////////////////////////	
		
	/** Retrieve the xml element tag for this class.	*/
	static QString xmlTag();
	
	/** Retrieve an xml element in DOM format that describes the projectList.
			@param doc DOM document for generating DOM nodes
		*/
	QDomElement domElement(QDomDocument* doc);
	
	/** Initialize the projectList with data from an xml element in DOM format.
			@param eProjectList DOM element containing projectList data
		*/
	void domElement(QDomElement eProjectList);
	
signals:
	void projectAdded(KFMProject* project);
	void projectRemoved(KFMProject* project, int pos);
	void currentProjectChanged(KFMProject* project);
	void contentsChanged();
	
private:  // Private Attributes
	mutable QSortedList<KFMProject> projectList_;
	KFMProject* currentProject_;
	
	/** Id to assign to the next project added to the projectlist */
	int nextProjectId_;
	
private:  // Private Methods
	/** Get the next project id */
	int nextProjectId() {return nextProjectId_;};
	/** Notify the projectlist of an existing project id.  This method may
			or may not alter the value of nextProjectId() */
	void existingProjectId(const int existingProjectId);
	
	
private slots:
	void onComponentContentsChanged();

};

#endif
