/***************************************************************************
                          kfocuslog.h  -  description
                             -------------------
    begin                : Fri Aug 17 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSLOG_H
#define KFOCUSLOG_H

#include <qobject.h>
#include <qsortedlist.h>
#include <qdom.h>
#include <qstring.h>
#include <qdatetime.h>

// Forward declaration of KFocus classes
class KFMLog;

/**Model class for a logbook
  *@author Jeffrey Yu
  */

class KFMLogBook : public QObject  {
	Q_OBJECT
public: 
	KFMLogBook();
	~KFMLogBook();

	/////////////////////////////////////////////////
	typedef QListIterator<KFMLog> Iterator;
	Iterator logIterator() const {return Iterator(*entryList_);};

	/** XML tag for this object */
	static QString xmlTag();
	/** Form a DOM element from the logBook */
	QDomElement domElement(QDomDocument* dDoc);
  /** Setup a logBook from a DOM element */
  void domElement(QDomElement eLog);

  /** Toggle sorting on and off */
  void sorted(bool sorted);

  /** Get the name of the logBook */
  QString name() const;
  /** Set the name of the logBook */
  void name(QString name);

  /** See how many entries are in the logBook */
  int numEntries() const;
  /** Query if an entry is in the logBook */
  bool isEntry(KFMLog* entry) const;
  /** Add an entry to the logBook */
  void addEntry(KFMLog* entry);
  /** Remove an entry from the logBook */
  void removeEntry(KFMLog* entry);
  /** Remove all entries from the list */
  void clearEntries();

  /** Change the date of an entry */
  void redateEntry(KFMLog* entry, QDate date);

  /** Retrieve the current entry */
  KFMLog* currentEntry() const;
  /** Change the current entry */
  void currentEntry(KFMLog* entry);

  /** Retrieve the position of the current entry */
  int currentPosition() const;
  /** Make the entry at pos the current entry */
  void currentPosition(int pos);

  /** Retrieve the first entry in the logBook  */
  KFMLog* firstEntry() const;
  /** Get the next entry in the logBook (after the current entry) */
  KFMLog* nextEntry() const;
  /** Retrieve the last entry in the logBook */
  KFMLog* lastEntry() const;

signals: // Signals
  /** Signal send when the name of the logBook is changed */
  void nameChanged(QString name);
  /** Signal sent after an entry is added */
  void entryAdded(KFMLog* entry);
  /** Signal sent when a logentry is removed.  Entry is NULL if all entries were removed. */
  void entryRemoved(KFMLog* entry, int pos);
  /** Signal for when logBook contents change */
  void contentsChanged();

private: // Private methods
	/** Sort the logs in the logbook. */
	void sort();

	/** Set the position fields of logs in the logbook.  This is normally
			called before sorting the logbook to preserve the relative order of logs
			that are equal. */
	void setLogPositions();

private slots: // Private slots
  /** Slot for when a logentry is changed */
  void onEntryContentsChanged();
  /** Slot to receive dateChanged signal from an entry */
  void onEntryDateChanged(KFMLog* entry);

private: // Private attributes
  /** List of entries */
  QSortedList<KFMLog>* entryList_;
  /** Name of the logBook */
  QString name_;
  /** Boolean indicating sort state */
  bool sorted_;
  /** Current entry in the logbook */
  KFMLog* currentEntry_;
};

#endif
