/***************************************************************************
                          kfocusview.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 08:36:08 PDT 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qhbox.h>
#include <qlayout.h>
#include <kmessagebox.h>

// application specific includes
#include "kfocusview.h"

#include "kfocusdoc.h"
#include "kfocus.h"
#include "kfvprojectlist.h"

KFocusView::KFocusView(QWidget *parent, const char *name) : QWidget(parent, name)
{
  //setBackgroundMode(PaletteBase);
  createWidgets();

	enterBaseState();
	connect(getDocument(), SIGNAL( documentEmpty() ), this, SLOT( enterBaseState() ));
	connect(getDocument(), SIGNAL( fileLoaded() ), this, SLOT( enterActiveState() ));
}


KFocusView::~KFocusView()
{
}


KFocusDoc *KFocusView::getDocument() const
{
  KFocusApp *theApp=(KFocusApp *) parentWidget();

  return theApp->getDocument();
}


void KFocusView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}


/** Put the ui into the base state (empty doc) */
void KFocusView::enterBaseState(){
	vProjectList_->projectList(NULL);
	setEnabled(false);
}


/** Slot to put the view in an active state */
void KFocusView::enterActiveState(){
	setEnabled(true);
  vProjectList_->projectList(getDocument()->projectList());
}


/** Create the widgest that go in this view */
void KFocusView::createWidgets(){
	setMinimumSize(640, 320);

	QHBoxLayout* hbl1 = new QHBoxLayout(this);
		vProjectList_ = new KFVProjectList(this);
			hbl1->addWidget(vProjectList_);
	
}


