/***************************************************************************
                          ellipseitem.h  -  description
                             -------------------
    begin                : Sun Apr 29 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ELLIPSEITEM_H
#define ELLIPSEITEM_H

#include <rectitem.h>

/**
  * Ellipse item class. Class for ellipse decoration items.
  * @author Werner Stille
  */
class EllipseItem : public RectItem
{
public: 
  /** Constructor */
  EllipseItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  EllipseItem(KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  EllipseItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param fillStyle > 0 for pattern filled ellipse.
    * @param color color for ellipse.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param w width in cm.
    * @param h height in cm.
    * @param relSize relative line width.
    * @param ang rotation angle in degree.
    */
  EllipseItem(bool active, int fillStyle, const QString& color,
              double x, double y, double w, double h, double relSize,
              double ang = 0.0);
  /** Destructor */
  ~EllipseItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
#ifndef KPL_CLASSES_ONLY
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(QListViewItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
#endif
  virtual KplItem* copy() const;
};

#endif
