/***************************************************************************
                          ksteventmonitorentry.h  -  description
                             -------------------
    begin                : Tue Apr 6 2004
    copyright            : (C) 2000 by The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTEVENTMONITORENTRY_H
#define KSTEVENTMONITORENTRY_H

#include <math.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qvaluelist.h>
#include <qdom.h>
#include <qdict.h>
#include <qtimer.h>

#include "kstobject.h"
#include "kstdataobject.h"
#include "kstscalar.h"
#include "kstdebug.h"

namespace Equation {
  class Node;
  class Context;
}

class EventMonitorEntry : public KstDataObject {
public:
  EventMonitorEntry(const QString &in_tag);
  EventMonitorEntry(QDomElement &e);
  ~EventMonitorEntry();
  
  virtual UpdateType update(int updateCounter = -1);
  virtual void save(QTextStream &ts);
  virtual QString propertyString() const;
  virtual void _showDialog();

  bool needToEvaluate();
  bool isValid() const { return _bIsValid; }

  void log(const int& iIndex);
  QString getEvent( ) { return _strEvent; }
  QString getDescription( ) { return _strDescription; }
  KstDebug::LogLevel	getLevel( ) { return _level; }
  Equation::Node* getExpression( ) { return _pExpression; }
  bool getLogKstDebug( ) { return _bLogKstDebug; }
  bool getLogEMail( ) { return _bLogEMail; }
  bool getLogELOG( ) { return _bLogELOG; }
  QString getEMailRecipients( ) { return _strEMailRecipients; }
  QString getEMailSender( ) { return _strEMailSender; }
  QString getSMTPServer( ) { return _strSMTPServer; }
  
  void setEvent( const QString& str );
  void setDescription( const QString& str ) { _strDescription = str; }
  void setLevel( KstDebug::LogLevel level ) { _level = level; }
  void setExpression( Equation::Node* pExpression ) { _pExpression = pExpression; }
  void setLogKstDebug( bool bLogKstDebug ) { _bLogKstDebug = bLogKstDebug; }
  void setLogEMail( bool bLogEMail ) { _bLogEMail = bLogEMail; }
  void setLogELOG( bool bLogELOG ) { _bLogELOG = bLogELOG; }
  void setEMailRecipients( const QString& str ) { _strEMailRecipients = str; }
  void setEMailSender( const QString& str ) { _strEMailSender = str; }
  void setSMTPServer( const QString& str ) { _strSMTPServer = str; }
  
public slots:    
  void logImmediately();

private:
  void commonConstructor(const QString &in_tag);

  static const QString OUTXVECTOR;
  static const QString OUTYVECTOR;

  KstVectorList       _vectorsUsed;
  QValueList<int>     _indexArray;
  QString             _strEvent;
  QString             _strDescription;
  QString             _strEMailRecipients;
  QString             _strEMailSender;
  QString             _strSMTPServer;
  KstDebug::LogLevel  _level;
  Equation::Node*     _pExpression;
  KstVectorMap::Iterator _xVector;
  KstVectorMap::Iterator _yVector;
  bool                _bLogKstDebug;
  bool                _bLogEMail;
  bool                _bLogELOG;
  bool                _bIsValid;
  int                 _iNumDone;
};

typedef KstSharedPtr<EventMonitorEntry> EventMonitorEntryPtr;
typedef KstObjectList<EventMonitorEntryPtr> KstEventMonitorEntryList;

#endif
