/***************************************************************************
                               kstviewwindow.h
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTVIEWWINDOW_H
#define KSTVIEWWINDOW_H

#include <config.h>

// include files for KDE
#include <kaccel.h>
#include <kaction.h>
#include <kapp.h>
#include <klineeditdlg.h>
#include <kmainwindow.h>
#include <kmdichildview.h>
#include <klocale.h>

#include "kstdatacollection.h"
#include "kstdataobject.h"
#include "ksttoplevelview.h"
#include "testview.h"

class QLabel;

/** The base class for Kst application view windows.
  */
class KstViewWindow : public KMdiChildView {
  Q_OBJECT
  public:
    KstViewWindow(QWidget* parent=0, const char* name=0);
    KstViewWindow(QDomElement& e, QWidget* parent=0, const char* name=0);
    virtual ~KstViewWindow();

    /** pause the updating of data */
    void setPaused(bool paused);
    void togglePaused();
    void save(QTextStream& ts);
    KstTopLevelViewPtr view() const;

  protected:
    /** save options to the configuration file
     *  Geometry, Toolbar status, Statusbar status */
    void saveOptions();

    /** read options from configuration file
     *  Geometry, Toolbar status, Statusbar status */
    void readOptions();

    /** setup kde2 actions and build the GUI */
    void initActions();

    /** sets up the statusbar for the main window */
    void initStatusBar();

    /** saves the window properties for each open window during session
     * end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KMainWindow#saveProperties */
    virtual void saveProperties(KConfig *_cfg);

    /** reads the session config file and restores the application's
     * state including the last opened files and documents by reading
     * the temporary files saved by saveProperties()
     * @see KMainWindow#readProperties */
    virtual void readProperties(KConfig *_cfg);

  private slots:
    // Hack to update KStdActions
    void updateActions();

    // for the kaction
    void toggleDataMode();

    void slotActivated(KMdiChildView*);

  public slots:
    /** asks for saving if the file is modified, then closes the actual
      file and window*/
    void slotFileClose();

    /** print the actual file */
    void slotFilePrint();

    /** print without querying */
    void immediatePrintToFile(const QString& filename);

    /** export to png without querying */
    void immediatePrintToPng(QDataStream* pStream, const QSize& size, const QString &format = "PNG");
    void immediatePrintToPng(const QString& filename, const QSize& size, const QString& format = "PNG");
    void slotCopy();

    /** calls doc->samplesDown */
    void samplesDown();

    /** calls doc->samplesUp */
    void samplesUp();

    /** calls doc->samplesEnd */
    void samplesEnd();

  public:
    template<class T> QString createPlot(const QString& suggestedName = QString::null, bool prompt = false);

  private:
    void commonConstructor();
  
    /** the configuration object of the application */
    KConfig *config;
    KstTopLevelViewPtr _view;
};


template<class T>
QString KstViewWindow::createPlot(const QString& suggestedName, bool prompt) {
  QString name = suggestedName;
  KstViewObjectPtr rc;
  if (!name.isEmpty()) {
    rc = _view->findChild(name);
  }

  while (name.isEmpty() || rc) {
    name = KST::suggestPlotName();
    rc = _view->findChild(name);
  }

  if (!prompt) {
    _view->createPlot<T>(name);
    return name;
  }

  bool ok = false;
  QString newName = name;
  do {
    newName = KLineEditDlg::getText(i18n("Enter a name for the new plot:"), newName, &ok, 0L);
    if (ok) {
      rc = _view->findChild(name);
      if (!rc) {
        _view->createPlot<T>(name);
        return name;
      }
    } else {
      break;
    }
  } while(true);

  return QString::null;
}


#endif
// vim: ts=2 sw=2 et
