/***************************************************************************
                       kstplotdialog_i.h  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2000-2002 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSTPLOTEDITI_H
#define KSTPLOTEDITI_H


#include <kcombobox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qspinbox.h>

#include "kst2dplot.h"
#include "kstbasecurve.h"
#include "kstdoc.h"
#include "plotdialog.h"

class KstLabel;

#define CONTENT_TAB   0
#define LIMITS_TAB    1
#define LABELS_TAB    2
#define LEGEND_TAB    3
#define MARKERS_TAB   4

class KstPlotDialogI : public KstPlotDialog {
  Q_OBJECT
  public:
    KstPlotDialogI(KstDoc *doc, QWidget *parent = 0, const char *name = 0,
                   bool modal = false, WFlags fl = 0);
    virtual ~KstPlotDialogI();

  public slots:
    /** Update info in the plot dialog */
    void updateWindow();
    void update(int new_index = -1);
    void newTab();

    /** Calls update(), then shows/raises the dialog */
    void show_I(const QString& strWindow, const QString& strPlot);
    void show_I();
    void new_I();
    void edit_I();
    void delete_I();

    /** update sample labels */
    void updateSampNumLabel();
    void updateSampTopLabel();
    void updateSampXLabel();
    void updateSampYLabel();
    void updateLabels();
    void updateSampLegendLabel();
    void updateCurveLists();
    void updateScalarCombo();
    void updateWindowList();
    void updatePlotList();

    void setScalarDestTopLabel() { ScalarDest = TopLabelText; }
    void setScalarDestXLabel() { ScalarDest = XAxisText; }
    void setScalarDestYLabel() { ScalarDest = YAxisText; }
    void insertCurrentScalar() { ScalarDest->insert(ScalarList->currentText()); }

    void applyLabels(Kst2DPlotPtr plot);
    void applyLegends(Kst2DPlotPtr plot);
    void applyLimits(Kst2DPlotPtr plot);

    void applyPlotColors(Kst2DPlotPtr plot);
    void applyPlotMarkers(Kst2DPlotPtr plot);

    void applyAutoLabels();

    void removeDisplayedCurve();
    void addDisplayedCurve();
    void removeDisplayedCurve(QListBoxItem*);
    void addDisplayedCurve(QListBoxItem*);

    /** plot markers **/
    void addPlotMarker();
    void removePlotMarker();
    void removeAllPlotMarkers();

    void updatePlotMarkers();

    void updateButtons();

    void newWindow();

  signals:
    void docChanged();
  private:
    void fill2DPlotList(Kst2DPlotList& plots);
    bool checkPlotName();
    KstDoc *doc;
    KstLabel *SampleLabel;
    QLineEdit *ScalarDest;
    QString _windowName;
    QString _plotName;
};

#endif
// vim: ts=2 sw=2 et
