/***************************************************************************
                          plugin.cpp  -  Part of KST
                             -------------------
    begin                : Tue May 06 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "plugin.h"

#include <klibloader.h>
#include <klocale.h>
#include <kdebug.h>


const int Plugin::CallError = -424242;

Plugin::Plugin() : KstShared() {
  _lib = 0L;
  _symbol = 0L;
  _parameterName = 0L;
  //kdDebug() << "Creating Plugin: " << long(this) << endl;
}


Plugin::~Plugin() {
  _symbol = 0L;
  _parameterName = 0L;

  if (_lib) {
    _lib->unload();  // this deletes it too
    _lib = 0L;
  }

  //kdDebug() << "Destroying Plugin: " << long(this) << endl;
}


const QString& Plugin::xmlFile() const {
  return _xmlFile;
}


const QString& Plugin::soFile() const {
  return _soFile;
}


int Plugin::call(const double *const inArrays[], const int inArrayLens[],
                 const double inScalars[], double *outArrays[],
                 int outArrayLens[], double outScalars[], void** local) const {
  if (!_symbol) {
    return CallError;
  }

  return ((int(*)(const double *const[], const int[],
          const double[], double *[], int[],
          double[], void**))_symbol)
    (inArrays, inArrayLens, inScalars, outArrays, outArrayLens, outScalars, local);
}


int Plugin::call(const double *const inArrays[], const int inArrayLens[],
                 const double inScalars[], double *outArrays[],
                 int outArrayLens[], double outScalars[]) const {
  if (!_symbol) {
    return CallError;
  }

  return ((int(*)(const double *const[], const int[],
          const double[], double *[], int[],
          double[]))_symbol)
    (inArrays, inArrayLens, inScalars, outArrays, outArrayLens, outScalars);
}


QString Plugin::parameterName(int iIndex) {
  QString strParameter;
  char* pName = 0L;
  
  if (_data._isFit && _parameterName) {
    if (((int(*)(int, char**))_parameterName)(iIndex, &pName) && pName) {
      strParameter = pName; // deep copy into QString
      free(pName);
    }
  }

  if (strParameter.isEmpty()) {
    strParameter = i18n("Param%1").arg(iIndex);
  }
  
  return strParameter;
}


const Plugin::Data& Plugin::data() const {
  return _data;
}


void Plugin::Data::clear() {
  _isFilter = false;
  _localdata = false;
  _name = QString::null;
  _readableName = QString::null;
  _author = QString::null;
  _description = QString::null;
  _version = QString::null;
  _filterInputVector = QString::null;
  _filterOutputVector = QString::null;
  _state = Unknown;
  _isFit = false;
  _isFitWeighted = false;
  
  _inputs.clear();
  _outputs.clear();
  _parameters.clear();
}

// vim: ts=2 sw=2 et
